/*
 * Decompiled with CFR 0.152.
 */
package xyz.capybara.clamav.commands.scan;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.SocketChannel;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import xyz.capybara.clamav.CommunicationException;
import xyz.capybara.clamav.commands.Command;
import xyz.capybara.clamav.commands.scan.ScanCommand;
import xyz.capybara.clamav.commands.scan.result.ScanResult;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\f8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lxyz/capybara/clamav/commands/scan/InStream;", "Lxyz/capybara/clamav/commands/scan/ScanCommand;", "inputStream", "Ljava/io/InputStream;", "(Ljava/io/InputStream;)V", "CHUNK_SIZE", "", "commandString", "", "getCommandString", "()Ljava/lang/String;", "format", "Lxyz/capybara/clamav/commands/Command$CommandFormat;", "getFormat", "()Lxyz/capybara/clamav/commands/Command$CommandFormat;", "send", "Lxyz/capybara/clamav/commands/scan/result/ScanResult;", "server", "Ljava/net/InetSocketAddress;", "clamav-client"})
public final class InStream
extends ScanCommand {
    private final int CHUNK_SIZE = 2048;
    private final InputStream inputStream;

    @Override
    @NotNull
    public String getCommandString() {
        return "INSTREAM";
    }

    @Override
    @NotNull
    protected Command.CommandFormat getFormat() {
        return Command.CommandFormat.NULL_CHAR;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public ScanResult send(@NotNull InetSocketAddress server) {
        Intrinsics.checkParameterIsNotNull((Object)server, (String)"server");
        try {
            Closeable closeable = SocketChannel.open(server);
            boolean bl = false;
            try {
                SocketChannel it = (SocketChannel)closeable;
                it.write(this.getRawCommand());
                ByteBuffer length = ByteBuffer.allocate(4).order(ByteOrder.BIG_ENDIAN);
                byte[] data = new byte[this.CHUNK_SIZE];
                int chunkSize = this.CHUNK_SIZE;
                while (chunkSize == this.CHUNK_SIZE) {
                    chunkSize = this.inputStream.read(data);
                    if (chunkSize <= 0) continue;
                    length.clear();
                    length.putInt(chunkSize).flip();
                    it.write(length);
                    it.write(ByteBuffer.wrap(data, 0, chunkSize));
                }
                length.clear();
                length.putInt(0).flip();
                it.write(length);
                SocketChannel socketChannel = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)socketChannel, (String)"it");
                ScanResult scanResult = (ScanResult)this.readResponse(socketChannel);
                return scanResult;
            }
            catch (Exception exception) {
                bl = true;
                try {
                    Closeable closeable2 = closeable;
                    if (closeable2 != null) {
                        closeable2.close();
                    }
                }
                catch (Exception exception2) {
                    // empty catch block
                }
                throw (Throwable)exception;
            }
            finally {
                if (!bl) {
                    Closeable closeable3 = closeable;
                    if (closeable3 != null) {
                        closeable3.close();
                    }
                }
            }
        }
        catch (IOException e) {
            throw (Throwable)new CommunicationException(e);
        }
    }

    public InStream(@NotNull InputStream inputStream) {
        Intrinsics.checkParameterIsNotNull((Object)inputStream, (String)"inputStream");
        this.inputStream = inputStream;
        this.CHUNK_SIZE = 2048;
    }
}

