/*
 * Decompiled with CFR 0.152.
 */
package dalma.container;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.bcel.util.ClassLoaderRepository;
import org.apache.bcel.util.Repository;
import org.apache.commons.javaflow.bytecode.transformation.ResourceTransformer;
import org.apache.commons.javaflow.bytecode.transformation.bcel.BcelClassTransformer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ClassLoaderImpl
extends ClassLoader {
    private static final Logger logger = Logger.getLogger(ClassLoaderImpl.class.getName());
    private static final int BUFFER_SIZE = 8192;
    private Vector<File> pathComponents = new Vector();
    private boolean parentFirst = true;
    private Vector<String> systemPackages = new Vector();
    private Vector<String> loaderPackages = new Vector();
    private boolean ignoreBase = false;
    private ClassLoader parent = null;
    private Hashtable<File, ZipFile> zipFiles = new Hashtable();
    private ResourceTransformer transformer;
    private static Map<String, String> pathMap = Collections.synchronizedMap(new HashMap());

    public ClassLoaderImpl(ClassLoader cl) {
        this.setParent(cl);
    }

    public void setParent(ClassLoader parent) {
        this.parent = parent == null ? this.getClass().getClassLoader() : parent;
    }

    public void setTransformer(ResourceTransformer transformer) {
        this.transformer = transformer;
    }

    public void makeContinuable() {
        this.setTransformer((ResourceTransformer)new BcelClassTransformer((Repository)new ClassLoaderRepository((ClassLoader)this)));
    }

    public void setParentFirst(boolean parentFirst) {
        this.parentFirst = parentFirst;
    }

    public void addJarFiles(File dir) throws IOException {
        File[] jarFiles = dir.listFiles(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return name.endsWith(".jar");
            }
        });
        if (jarFiles == null) {
            return;
        }
        for (File jar : jarFiles) {
            this.addPathFile(jar);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addPathFile(File pathComponent) throws IOException {
        this.pathComponents.addElement(pathComponent);
        if (pathComponent.isDirectory()) {
            return;
        }
        String absPathPlusTimeAndLength = pathComponent.getAbsolutePath() + pathComponent.lastModified() + "-" + pathComponent.length();
        String classpath = pathMap.get(absPathPlusTimeAndLength);
        if (classpath == null) {
            ZipFile jarFile = null;
            InputStream manifestStream = null;
            try {
                jarFile = new ZipFile(pathComponent);
                manifestStream = jarFile.getInputStream(new ZipEntry("META-INF/MANIFEST.MF"));
                if (manifestStream == null) {
                    return;
                }
                Manifest manifest = new Manifest(manifestStream);
                classpath = manifest.getMainAttributes().getValue("Class-Path");
            }
            finally {
                if (manifestStream != null) {
                    manifestStream.close();
                }
                if (jarFile != null) {
                    jarFile.close();
                }
            }
            if (classpath == null) {
                classpath = "";
            }
            pathMap.put(absPathPlusTimeAndLength, classpath);
        }
        if (!"".equals(classpath)) {
            URL baseURL = pathComponent.toURL();
            StringTokenizer st = new StringTokenizer(classpath);
            while (st.hasMoreTokens()) {
                String classpathElement = st.nextToken();
                URL libraryURL = new URL(baseURL, classpathElement);
                if (!libraryURL.getProtocol().equals("file")) {
                    logger.fine("Skipping jar library " + classpathElement + " since only relative URLs are supported by this" + " loader");
                    continue;
                }
                File libraryFile = new File(libraryURL.getFile());
                if (!libraryFile.exists() || this.isInPath(libraryFile)) continue;
                this.addPathFile(libraryFile);
            }
        }
    }

    public String getClasspath() {
        StringBuffer sb = new StringBuffer();
        boolean firstPass = true;
        Enumeration<File> componentEnum = this.pathComponents.elements();
        while (componentEnum.hasMoreElements()) {
            if (!firstPass) {
                sb.append(System.getProperty("path.separator"));
            } else {
                firstPass = false;
            }
            sb.append(componentEnum.nextElement().getAbsolutePath());
        }
        return sb.toString();
    }

    public synchronized void setIsolated(boolean isolated) {
        this.ignoreBase = isolated;
    }

    public void addSystemPackageRoot(String packageRoot) {
        this.systemPackages.addElement(packageRoot + (packageRoot.endsWith(".") ? "" : "."));
    }

    public void addLoaderPackageRoot(String packageRoot) {
        this.loaderPackages.addElement(packageRoot + (packageRoot.endsWith(".") ? "" : "."));
    }

    public Class forceLoadClass(String classname) throws ClassNotFoundException {
        logger.finer("force loading " + classname);
        Class theClass = this.findLoadedClass(classname);
        if (theClass == null) {
            theClass = this.findClass(classname);
        }
        return theClass;
    }

    public Class forceLoadSystemClass(String classname) throws ClassNotFoundException {
        logger.finer("force system loading " + classname);
        Class theClass = this.findLoadedClass(classname);
        if (theClass == null) {
            theClass = this.findBaseClass(classname);
        }
        return theClass;
    }

    @Override
    public InputStream getResourceAsStream(String name) {
        InputStream resourceStream;
        if (this.isParentFirst(name)) {
            resourceStream = this.loadBaseResource(name);
            if (resourceStream != null) {
                logger.finer("ResourceStream for " + name + " loaded from parent loader");
            } else {
                resourceStream = this.loadResource(name);
                if (resourceStream != null) {
                    logger.finer("ResourceStream for " + name + " loaded from ant loader");
                }
            }
        } else {
            resourceStream = this.loadResource(name);
            if (resourceStream != null) {
                logger.finer("ResourceStream for " + name + " loaded from ant loader");
            } else {
                resourceStream = this.loadBaseResource(name);
                if (resourceStream != null) {
                    logger.finer("ResourceStream for " + name + " loaded from parent loader");
                }
            }
        }
        if (resourceStream == null) {
            logger.finer("Couldn't load ResourceStream for " + name);
        }
        return resourceStream;
    }

    private InputStream loadResource(String name) {
        InputStream stream = null;
        Enumeration<File> e = this.pathComponents.elements();
        while (e.hasMoreElements() && stream == null) {
            File pathComponent = e.nextElement();
            stream = this.getResourceStream(pathComponent, name);
        }
        return stream;
    }

    private InputStream loadBaseResource(String name) {
        if (this.parent == null) {
            return ClassLoaderImpl.getSystemResourceAsStream(name);
        }
        return this.parent.getResourceAsStream(name);
    }

    private InputStream getResourceStream(File file, String resourceName) {
        try {
            if (!file.exists()) {
                return null;
            }
            if (file.isDirectory()) {
                File resource = new File(file, resourceName);
                if (resource.exists()) {
                    return new FileInputStream(resource);
                }
            } else {
                ZipEntry entry;
                ZipFile zipFile = this.zipFiles.get(file);
                if (zipFile == null) {
                    zipFile = new ZipFile(file);
                    this.zipFiles.put(file, zipFile);
                }
                if ((entry = zipFile.getEntry(resourceName)) != null) {
                    return zipFile.getInputStream(entry);
                }
            }
        }
        catch (Exception e) {
            logger.fine("Ignoring Exception " + e.getClass().getName() + ": " + e.getMessage() + " reading resource " + resourceName + " from " + file);
        }
        return null;
    }

    private boolean isParentFirst(String resourceName) {
        String packageName;
        boolean useParentFirst = this.parentFirst;
        Enumeration<String> e = this.systemPackages.elements();
        while (e.hasMoreElements()) {
            packageName = e.nextElement();
            if (!resourceName.startsWith(packageName)) continue;
            useParentFirst = true;
            break;
        }
        e = this.loaderPackages.elements();
        while (e.hasMoreElements()) {
            packageName = e.nextElement();
            if (!resourceName.startsWith(packageName)) continue;
            useParentFirst = false;
            break;
        }
        return useParentFirst;
    }

    @Override
    public URL getResource(String name) {
        URL url = null;
        if (this.isParentFirst(name)) {
            URL uRL = url = this.parent == null ? super.getResource(name) : this.parent.getResource(name);
        }
        if (url != null) {
            logger.finer("Resource " + name + " loaded from parent loader");
        } else {
            Enumeration<File> e = this.pathComponents.elements();
            while (e.hasMoreElements() && url == null) {
                File pathComponent = e.nextElement();
                url = this.getResourceURL(pathComponent, name);
                if (url == null) continue;
                logger.finer("Resource " + name + " loaded from ant loader");
            }
        }
        if (url == null && !this.isParentFirst(name)) {
            URL uRL = url = this.parent == null ? super.getResource(name) : this.parent.getResource(name);
            if (url != null) {
                logger.finer("Resource " + name + " loaded from parent loader");
            }
        }
        if (url == null) {
            logger.finer("Couldn't load Resource " + name);
        }
        return url;
    }

    @Override
    protected Enumeration<URL> findResources(String name) {
        return new ResourceEnumeration(name);
    }

    protected URL getResourceURL(File file, String resourceName) {
        try {
            if (!file.exists()) {
                return null;
            }
            if (file.isDirectory()) {
                File resource = new File(file, resourceName);
                if (resource.exists()) {
                    try {
                        return resource.toURL();
                    }
                    catch (MalformedURLException ex) {
                        return null;
                    }
                }
            } else {
                ZipEntry entry;
                ZipFile zipFile = this.zipFiles.get(file);
                if (zipFile == null) {
                    zipFile = new ZipFile(file);
                    this.zipFiles.put(file, zipFile);
                }
                if ((entry = zipFile.getEntry(resourceName)) != null) {
                    try {
                        return new URL("jar:" + file.toURL() + "!/" + entry);
                    }
                    catch (MalformedURLException ex) {
                        return null;
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    protected synchronized Class loadClass(String classname, boolean resolve) throws ClassNotFoundException {
        Class theClass = this.findLoadedClass(classname);
        if (theClass != null) {
            return theClass;
        }
        if (this.isParentFirst(classname)) {
            try {
                theClass = this.findBaseClass(classname);
                logger.finer("Class " + classname + " loaded from parent loader " + "(parentFirst)");
            }
            catch (ClassNotFoundException cnfe) {
                theClass = this.findClass(classname);
                logger.finer("Class " + classname + " loaded from ant loader " + "(parentFirst)");
            }
        } else {
            try {
                theClass = this.findClass(classname);
                logger.finer("Class " + classname + " loaded from ant loader");
            }
            catch (ClassNotFoundException cnfe) {
                if (this.ignoreBase) {
                    throw cnfe;
                }
                theClass = this.findBaseClass(classname);
                logger.finer("Class " + classname + " loaded from parent loader");
            }
        }
        if (resolve) {
            this.resolveClass(theClass);
        }
        return theClass;
    }

    private String getClassFilename(String classname) {
        return classname.replace('.', '/') + ".class";
    }

    protected Class defineClassFromData(File container, byte[] classData, String className) throws IOException {
        if (this.transformer != null) {
            classData = this.transformer.transform(classData);
        }
        this.definePackage(container, className);
        return this.defineClass(className, classData, 0, classData.length, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Manifest getJarManifest(File container) throws IOException {
        if (container.isDirectory()) {
            return null;
        }
        JarFile jarFile = null;
        try {
            jarFile = new JarFile(container);
            Manifest manifest = jarFile.getManifest();
            return manifest;
        }
        finally {
            if (jarFile != null) {
                jarFile.close();
            }
        }
    }

    protected void definePackage(File container, String className) throws IOException {
        int classIndex = className.lastIndexOf(46);
        if (classIndex == -1) {
            return;
        }
        String packageName = className.substring(0, classIndex);
        if (this.getPackage(packageName) != null) {
            return;
        }
        Manifest manifest = this.getJarManifest(container);
        if (manifest == null) {
            this.definePackage(packageName, null, null, null, null, null, null, null);
        } else {
            this.definePackage(container, packageName, manifest);
        }
    }

    protected void definePackage(File container, String packageName, Manifest manifest) {
        Attributes mainAttributes;
        String sectionName = packageName.replace('.', '/') + "/";
        String specificationTitle = null;
        String specificationVendor = null;
        String specificationVersion = null;
        String implementationTitle = null;
        String implementationVendor = null;
        String implementationVersion = null;
        String sealedString = null;
        URL sealBase = null;
        Attributes sectionAttributes = manifest.getAttributes(sectionName);
        if (sectionAttributes != null) {
            specificationTitle = sectionAttributes.getValue(Attributes.Name.SPECIFICATION_TITLE);
            specificationVendor = sectionAttributes.getValue(Attributes.Name.SPECIFICATION_VENDOR);
            specificationVersion = sectionAttributes.getValue(Attributes.Name.SPECIFICATION_VERSION);
            implementationTitle = sectionAttributes.getValue(Attributes.Name.IMPLEMENTATION_TITLE);
            implementationVendor = sectionAttributes.getValue(Attributes.Name.IMPLEMENTATION_VENDOR);
            implementationVersion = sectionAttributes.getValue(Attributes.Name.IMPLEMENTATION_VERSION);
            sealedString = sectionAttributes.getValue(Attributes.Name.SEALED);
        }
        if ((mainAttributes = manifest.getMainAttributes()) != null) {
            if (specificationTitle == null) {
                specificationTitle = mainAttributes.getValue(Attributes.Name.SPECIFICATION_TITLE);
            }
            if (specificationVendor == null) {
                specificationVendor = mainAttributes.getValue(Attributes.Name.SPECIFICATION_VENDOR);
            }
            if (specificationVersion == null) {
                specificationVersion = mainAttributes.getValue(Attributes.Name.SPECIFICATION_VERSION);
            }
            if (implementationTitle == null) {
                implementationTitle = mainAttributes.getValue(Attributes.Name.IMPLEMENTATION_TITLE);
            }
            if (implementationVendor == null) {
                implementationVendor = mainAttributes.getValue(Attributes.Name.IMPLEMENTATION_VENDOR);
            }
            if (implementationVersion == null) {
                implementationVersion = mainAttributes.getValue(Attributes.Name.IMPLEMENTATION_VERSION);
            }
            if (sealedString == null) {
                sealedString = mainAttributes.getValue(Attributes.Name.SEALED);
            }
        }
        if (sealedString != null && sealedString.equalsIgnoreCase("true")) {
            try {
                sealBase = new URL("file:" + container.getPath());
            }
            catch (MalformedURLException e) {
                // empty catch block
            }
        }
        this.definePackage(packageName, specificationTitle, specificationVersion, specificationVendor, implementationTitle, implementationVersion, implementationVendor, sealBase);
    }

    private Class getClassFromStream(InputStream stream, String classname, File container) throws IOException, SecurityException {
        int bytesRead;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] buffer = new byte[8192];
        while ((bytesRead = stream.read(buffer, 0, 8192)) != -1) {
            baos.write(buffer, 0, bytesRead);
        }
        byte[] classData = baos.toByteArray();
        return this.defineClassFromData(container, classData, classname);
    }

    public Class findClass(String name) throws ClassNotFoundException {
        logger.finer("Finding class " + name);
        return this.findClassInComponents(name);
    }

    protected boolean isInPath(File component) {
        Enumeration<File> e = this.pathComponents.elements();
        while (e.hasMoreElements()) {
            File pathComponent = e.nextElement();
            if (!pathComponent.equals(component)) continue;
            return true;
        }
        return false;
    }

    private Class findClassInComponents(String name) throws ClassNotFoundException {
        InputStream stream = null;
        String classFilename = this.getClassFilename(name);
        try {
            Enumeration<File> e = this.pathComponents.elements();
            while (e.hasMoreElements()) {
                File pathComponent = e.nextElement();
                try {
                    stream = this.getResourceStream(pathComponent, classFilename);
                    if (stream == null) continue;
                    logger.finer("Loaded from " + pathComponent + " " + classFilename);
                    Class clazz = this.getClassFromStream(stream, name, pathComponent);
                    return clazz;
                }
                catch (SecurityException se) {
                    throw se;
                }
                catch (IOException ioe) {
                    logger.fine("Exception reading component " + pathComponent + " (reason: " + ioe.getMessage() + ")");
                }
            }
            throw new ClassNotFoundException(name);
        }
        finally {
            try {
                if (stream != null) {
                    stream.close();
                }
            }
            catch (IOException e) {}
        }
    }

    private Class findBaseClass(String name) throws ClassNotFoundException {
        if (this.parent == null) {
            return this.findSystemClass(name);
        }
        return this.parent.loadClass(name);
    }

    public synchronized void cleanup() {
        Enumeration<ZipFile> e = this.zipFiles.elements();
        while (e.hasMoreElements()) {
            ZipFile zipFile = e.nextElement();
            try {
                zipFile.close();
            }
            catch (IOException iOException) {}
        }
        this.zipFiles = new Hashtable();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ResourceEnumeration
    implements Enumeration<URL> {
        private String resourceName;
        private int pathElementsIndex;
        private URL nextResource;

        ResourceEnumeration(String name) {
            this.resourceName = name;
            this.pathElementsIndex = 0;
            this.findNextResource();
        }

        @Override
        public boolean hasMoreElements() {
            return this.nextResource != null;
        }

        @Override
        public URL nextElement() {
            URL ret = this.nextResource;
            this.findNextResource();
            return ret;
        }

        private void findNextResource() {
            URL url = null;
            while (this.pathElementsIndex < ClassLoaderImpl.this.pathComponents.size() && url == null) {
                File pathComponent = (File)ClassLoaderImpl.this.pathComponents.elementAt(this.pathElementsIndex);
                url = ClassLoaderImpl.this.getResourceURL(pathComponent, this.resourceName);
                ++this.pathElementsIndex;
            }
            this.nextResource = url;
        }
    }
}

