/*
 * Decompiled with CFR 0.152.
 */
package dalma.container;

import dalma.Conversation;
import dalma.ConversationState;
import dalma.Engine;
import dalma.impl.XmlFile;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.logging.LogRecord;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class CompletedConversation
implements Conversation,
Serializable {
    private final int id;
    private final String title;
    private final long startDate;
    private final long endDate;
    private final LogRecord[] logs;
    private transient List<LogRecord> logView;

    CompletedConversation(Conversation that) {
        this.id = that.getId();
        this.title = that.getTitle();
        this.startDate = that.getStartDate().getTime();
        this.endDate = that.getCompletionDate().getTime();
        List ll = that.getLog();
        this.logs = ll.toArray(new LogRecord[ll.size()]);
    }

    public int getId() {
        return this.id;
    }

    public Engine getEngine() {
        throw this.uoe();
    }

    public ConversationState getState() {
        return ConversationState.ENDED;
    }

    public void remove() {
        throw this.uoe();
    }

    public void join() {
        throw this.uoe();
    }

    public String getTitle() {
        return this.title;
    }

    public List<LogRecord> getLog() {
        if (this.logView == null) {
            this.logView = Collections.unmodifiableList(Arrays.asList(this.logs));
        }
        return this.logView;
    }

    public Date getStartDate() {
        return new Date(this.startDate);
    }

    public Date getCompletionDate() {
        return new Date(this.endDate);
    }

    private UnsupportedOperationException uoe() {
        return new UnsupportedOperationException("This operation is not available on the completed conversation");
    }

    public static CompletedConversation load(File file) throws IOException {
        return (CompletedConversation)new XmlFile(file).read();
    }

    public void save(File file) throws IOException {
        new XmlFile(file).write((Object)this);
    }
}

