/*
 * Decompiled with CFR 0.152.
 */
package dalma.container;

import dalma.Conversation;
import dalma.container.CompletedConversation;
import dalma.container.LogRotationPolicy;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Observable;
import java.util.TreeMap;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class CompletedConversationList
extends Observable {
    private final File dir;
    private transient long nextUpdate = 0L;
    private transient boolean reloadingInProgress;
    private Map<Integer, CompletedConversation> convs;
    private transient LogRotationPolicy policy = LogRotationPolicy.NEVER;
    private final Runnable reloadTask = new Runnable(){

        public void run() {
            Map<Integer, CompletedConversation> convs = new TreeMap();
            convs = Collections.synchronizedMap(convs);
            File[] data = CompletedConversationList.this.dir.listFiles(new FileFilter(){

                public boolean accept(File file) {
                    return file.getPath().endsWith(".dat");
                }
            });
            if (data != null) {
                for (File dt : data) {
                    try {
                        CompletedConversation conv = CompletedConversation.load(dt);
                        convs.put(conv.getId(), conv);
                    }
                    catch (IOException e) {
                        logger.log(Level.WARNING, "Unable to load " + dt, e);
                        dt.delete();
                    }
                }
            }
            CompletedConversationList.this.applyLogRotation(convs);
            CompletedConversationList.this.convs = convs;
            CompletedConversationList.this.reloadingInProgress = false;
            CompletedConversationList.this.nextUpdate = System.currentTimeMillis() + 5000L;
        }
    };
    private static final Executor reloader = Executors.newSingleThreadExecutor(new ThreadFactory(){

        public Thread newThread(Runnable r) {
            Thread t = new Thread(r);
            t.setDaemon(true);
            return t;
        }
    });
    private static final Logger logger = Logger.getLogger(CompletedConversationList.class.getName());

    public CompletedConversationList(File dir) {
        this.dir = dir;
        this.scheduleReload();
    }

    private File getDataFile(Conversation conv) {
        return new File(this.dir, String.format("%06d.dat", conv.getId()));
    }

    public void setPolicy(LogRotationPolicy policy) {
        this.policy = policy;
        this.scheduleReload();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(Conversation _conv) {
        this.loadSync();
        CompletedConversation conv = new CompletedConversation(_conv);
        Map<Integer, CompletedConversation> map = this.convs;
        synchronized (map) {
            this.convs.put(conv.getId(), conv);
            this.applyLogRotation(this.convs);
        }
        File dt = this.getDataFile(conv);
        try {
            conv.save(dt);
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "Unable to save " + dt, e);
        }
    }

    public void remove(Conversation conv) {
        this.loadSync();
        if (this.convs.remove(conv.getId()) == null) {
            throw new IllegalArgumentException();
        }
        this.getDataFile(conv).delete();
    }

    public Map<Integer, Conversation> getList() {
        this.loadSync();
        if (this.nextUpdate < System.currentTimeMillis() && !this.reloadingInProgress) {
            this.scheduleReload();
        }
        return new HashMap<Integer, Conversation>(this.convs);
    }

    private synchronized void scheduleReload() {
        if (!this.reloadingInProgress) {
            this.reloadingInProgress = true;
            reloader.execute(this.reloadTask);
        }
    }

    private void loadSync() {
        if (this.convs == null) {
            this.reloadTask.run();
        }
    }

    private void applyLogRotation(Map<Integer, CompletedConversation> convs) {
        Iterator<Map.Entry<Integer, CompletedConversation>> itr = convs.entrySet().iterator();
        while (itr.hasNext()) {
            CompletedConversation c = itr.next().getValue();
            if (this.policy.keep(c)) continue;
            itr.remove();
        }
    }
}

