/*
 * Decompiled with CFR 0.152.
 */
package dalma.container;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import javax.management.JMException;
import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import javax.management.StandardMBean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class MBeanProxy
implements InvocationHandler,
MBeanRegistration {
    private final ReferenceImpl real;
    private MBeanServer server;
    private ObjectName name;
    private static final ReferenceQueue<Object> queue = new ReferenceQueue();

    public static <T> void register(MBeanServer server, ObjectName name, Class<T> mbeanInterface, T object) throws JMException {
        T proxy = mbeanInterface.cast(Proxy.newProxyInstance(mbeanInterface.getClassLoader(), new Class[]{mbeanInterface, MBeanRegistration.class}, (InvocationHandler)new MBeanProxy(object)));
        if (server.isRegistered(name)) {
            try {
                server.unregisterMBean(name);
            }
            catch (JMException e) {
                // empty catch block
            }
        }
        server.registerMBean(new StandardMBeanEx((Object)proxy, (Class)mbeanInterface), name);
    }

    private MBeanProxy(Object realObject) {
        this.real = new ReferenceImpl(realObject);
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Object o = this.real.get();
        if (method.getDeclaringClass() == MBeanRegistration.class) {
            o = this;
        }
        if (o == null) {
            this.unregister();
            throw new IllegalStateException(this.name + " no longer exists");
        }
        try {
            return method.invoke(o, args);
        }
        catch (InvocationTargetException e) {
            if (e.getCause() != null) {
                throw e.getCause();
            }
            throw e;
        }
    }

    private synchronized void unregister() {
        try {
            this.server.unregisterMBean(this.name);
        }
        catch (JMException e) {
            throw new Error(e);
        }
    }

    @Override
    public synchronized ObjectName preRegister(MBeanServer server, ObjectName name) throws Exception {
        this.server = server;
        this.name = name;
        return name;
    }

    @Override
    public void postRegister(Boolean registrationDone) {
    }

    @Override
    public void preDeregister() throws Exception {
    }

    @Override
    public synchronized void postDeregister() {
        this.server = null;
        this.name = null;
    }

    static {
        Runnable r = new Runnable(){

            public void run() {
                while (true) {
                    ReferenceImpl ref;
                    try {
                        ref = (ReferenceImpl)((WeakReference)queue.remove());
                    }
                    catch (InterruptedException e) {
                        return;
                    }
                    ref.getProxy().unregister();
                }
            }
        };
        Thread t = new Thread(r, "Dalma JMX bean clenaer");
        t.setDaemon(true);
        t.start();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ReferenceImpl
    extends WeakReference<Object> {
        public ReferenceImpl(Object referent) {
            super(referent, queue);
        }

        public MBeanProxy getProxy() {
            return MBeanProxy.this;
        }
    }

    private static class StandardMBeanEx
    extends StandardMBean
    implements MBeanRegistration {
        private MBeanRegistration mbr;

        public StandardMBeanEx(Object implementation, Class mbeanInterface) throws NotCompliantMBeanException {
            super(implementation, mbeanInterface);
            this.mbr = (MBeanRegistration)implementation;
        }

        public ObjectName preRegister(MBeanServer server, ObjectName name) throws Exception {
            return this.mbr.preRegister(server, name);
        }

        public void postRegister(Boolean registrationDone) {
            this.mbr.postRegister(registrationDone);
        }

        public void preDeregister() throws Exception {
            this.mbr.preDeregister();
        }

        public void postDeregister() {
            this.mbr.postDeregister();
        }
    }
}

