/*
 * Decompiled with CFR 0.152.
 */
package dalma.container;

import dalma.container.Container;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;

public class Main {
    private static final Logger logger = Logger.getLogger(Main.class.getName());

    public static void main(String[] args) throws Exception {
        File home = Main.getHome();
        logger.info("Starting dalma container with DALMA_HOME=" + home);
        Container container = Container.create(home);
        Thread.currentThread().suspend();
    }

    public static File getHome() {
        String home = System.getProperty("DALMA_HOME");
        if (home != null) {
            return new File(home);
        }
        return new File(".");
    }

    public static File getConfigFile(String name) {
        return new File(new File(Main.getHome(), "conf"), name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void configureLogger() {
        Logger.getLogger("dalma").setLevel(Level.ALL);
        File logProperties = Main.getConfigFile("logging.properties");
        if (logProperties.exists()) {
            try {
                FileInputStream in = new FileInputStream(logProperties);
                try {
                    LogManager.getLogManager().readConfiguration(in);
                }
                finally {
                    in.close();
                }
            }
            catch (IOException e) {
                logger.log(Level.SEVERE, "Failed to read " + logProperties, e);
            }
        }
    }

    static {
        Main.configureLogger();
    }
}

