/*
 * Decompiled with CFR 0.152.
 */
package dalma.container;

import dalma.container.Container;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class Module {
    public final Container owner;
    public final File dir;
    public final Manifest manifest;
    private static final Logger logger = Logger.getLogger(Module.class.getName());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Module(Container owner, File dir) {
        this.owner = owner;
        this.dir = dir;
        this.manifest = new Manifest();
        File manifestFile = new File(dir, "META-INF/MANIFEST.MF");
        if (manifestFile.exists()) {
            try {
                BufferedInputStream is = new BufferedInputStream(new FileInputStream(manifestFile));
                try {
                    this.manifest.read(is);
                }
                finally {
                    ((InputStream)is).close();
                }
            }
            catch (IOException e) {
                logger.log(Level.WARNING, "Failed to read manifest file " + manifestFile, e);
            }
        }
    }

    public String getTitle() {
        Attributes atts = this.manifest.getMainAttributes();
        String value = atts.getValue(Attributes.Name.SPECIFICATION_TITLE);
        if (value != null) {
            return value;
        }
        value = atts.getValue(Attributes.Name.IMPLEMENTATION_TITLE);
        if (value != null) {
            return value;
        }
        return null;
    }

    public String getName() {
        return this.dir.getName();
    }
}

