/*
 * Decompiled with CFR 0.152.
 */
package dalma.container;

import dalma.Conversation;
import dalma.Description;
import dalma.Engine;
import dalma.EngineListener;
import dalma.Program;
import dalma.container.ClassLoaderImpl;
import dalma.container.CompletedConversationList;
import dalma.container.Container;
import dalma.container.FailedOperationException;
import dalma.container.LogRotationPolicy;
import dalma.container.MBeanProxy;
import dalma.container.WorkflowApplicationMBean;
import dalma.container.WorkflowState;
import dalma.container.model.IllegalResourceException;
import dalma.container.model.InjectionException;
import dalma.container.model.Model;
import dalma.impl.EngineImpl;
import dalma.impl.Util;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.Map;
import java.util.Properties;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.JMException;
import javax.management.ObjectName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class WorkflowApplication
implements WorkflowApplicationMBean {
    private static final Logger logger = Logger.getLogger(WorkflowApplication.class.getName());
    private final String name;
    private Engine engine;
    private ClassLoaderImpl classLoader;
    private Class<?> mainClass;
    private Model<?> model;
    public final Container owner;
    private final File workDir;
    private final File appDir;
    private final File confFile;
    private Program program;
    private ObjectName objectName;
    private WorkflowState state;
    private int logRotationDays = -1;
    private final LogRotationPolicy logPolicy = new LogRotationPolicy(){

        public boolean keep(Conversation conv) {
            if (WorkflowApplication.this.logRotationDays == -1) {
                return true;
            }
            GregorianCalendar cal = new GregorianCalendar();
            ((Calendar)cal).add(6, -WorkflowApplication.this.logRotationDays);
            return conv.getCompletionDate().getTime() > cal.getTimeInMillis();
        }
    };
    private final CompletedConversationList ccList;
    private final Object undeployLock = new Object();
    private boolean undeployed = false;
    private static final String LOG_ROTATION_KEY = "!log-rotation-days";

    public WorkflowApplication(Container owner, File appDir) throws FailedOperationException {
        this.owner = owner;
        this.name = appDir.getName();
        this.workDir = new File(new File(owner.getHomeDir(), "work"), this.name);
        this.confFile = new File(new File(new File(owner.getHomeDir(), "conf"), "apps"), this.name + ".properties");
        this.appDir = appDir;
        this.state = WorkflowState.UNLOADED;
        File clog = new File(this.workDir, "completed-logs");
        clog.mkdirs();
        this.ccList = new CompletedConversationList(clog);
        this.ccList.setPolicy(this.logPolicy);
        try {
            Properties props = this.loadConfigProperties();
            this.logRotationDays = Integer.parseInt(props.getProperty(LOG_ROTATION_KEY, "-1"));
        }
        catch (IOException e) {
            throw new FailedOperationException("Failed to load configuration " + this.confFile, e);
        }
        try {
            this.objectName = new ObjectName("dalma:container=" + ObjectName.quote(owner.getHomeDir().toString()) + ",name=" + this.name);
            MBeanProxy.register(owner.mbeanServer, this.objectName, WorkflowApplicationMBean.class, this);
        }
        catch (JMException e) {
            logger.log(Level.WARNING, "Failed to register to JMX", e);
        }
        this.load();
    }

    public void setLogRotationDays(int d) throws IOException {
        this.logRotationDays = d;
        Properties props = this.loadConfigProperties();
        props.setProperty(LOG_ROTATION_KEY, String.valueOf(d));
        this.saveConfigProperties(props);
        this.ccList.setPolicy(this.logPolicy);
    }

    public int getLogRotationDays() {
        return this.logRotationDays;
    }

    @Override
    public boolean isConfigured() {
        if (this.state == WorkflowState.UNLOADED) {
            return false;
        }
        try {
            return this.model.checkConfiguration(this.loadConfigProperties());
        }
        catch (IOException e) {
            WorkflowApplication.log("Failed to check the configuration", e);
            return false;
        }
    }

    @Override
    public synchronized void load() throws FailedOperationException {
        if (this.state != WorkflowState.UNLOADED) {
            return;
        }
        logger.info("Loading " + this.name);
        try {
            this.classLoader = this.createClassLoader();
        }
        catch (IOException e) {
            throw new FailedOperationException("Failed to set up a ClassLoader", e);
        }
        try {
            this.mainClass = this.classLoader.loadClass(this.findMainClass());
        }
        catch (ClassNotFoundException e) {
            throw new FailedOperationException("Failed to load the main class from application", e);
        }
        catch (IOException e) {
            throw new FailedOperationException("Failed to load the main class from application", e);
        }
        catch (LinkageError e) {
            throw new FailedOperationException("Failed to load the main class from application", e);
        }
        try {
            this.model = new Model(this.mainClass);
        }
        catch (IllegalResourceException e) {
            throw new FailedOperationException("Failed to configure program", e);
        }
        catch (LinkageError e) {
            throw new FailedOperationException("Failed to configure program", e);
        }
        this.state = WorkflowState.STOPPED;
        logger.info("Loaded " + this.name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String findMainClass() throws IOException {
        Enumeration<URL> res = this.classLoader.getResources("META-INF/MANIFEST.MF");
        while (res.hasMoreElements()) {
            URL url = res.nextElement();
            BufferedInputStream is = new BufferedInputStream(url.openStream());
            try {
                Manifest mf = new Manifest(is);
                String value = mf.getMainAttributes().getValue("Dalma-Main-Class");
                if (value == null) continue;
                logger.info("Found Dalma-Main-Class=" + value + " in " + url);
                String string = value;
                return string;
            }
            finally {
                ((InputStream)is).close();
            }
        }
        return "Main";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void start() throws FailedOperationException {
        this.load();
        if (this.state == WorkflowState.RUNNING) {
            return;
        }
        logger.info("Starting " + this.name);
        ClassLoader old = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.classLoader);
        try {
            Object main;
            block21: {
                try {
                    this.engine = new EngineImpl(new File(this.workDir, "data"), (ClassLoader)this.classLoader, this.owner.executor);
                }
                catch (IOException e) {
                    throw new FailedOperationException("Failed to start engine", e);
                }
                main = this.mainClass.newInstance();
                if (main instanceof Program) break block21;
                logger.severe(this.mainClass.getName() + " doesn't extend the Program class");
                return;
            }
            try {
                this.program = (Program)main;
                this.program.setLogger(logger);
            }
            catch (InstantiationException e) {
                throw new FailedOperationException("Failed to load the main class from application", e);
            }
            catch (IllegalAccessException e) {
                throw new FailedOperationException("Failed to load the main class from application", e);
            }
            try {
                this.model.inject(this.engine, this.program, this.loadConfigProperties());
            }
            catch (InjectionException e) {
                throw new FailedOperationException("Failed to configure program", e);
            }
            catch (ParseException e) {
                throw new FailedOperationException("Failed to configure program", e);
            }
            catch (IOException e) {
                throw new FailedOperationException("Failed to configure program", e);
            }
            try {
                this.program.init(this.engine);
            }
            catch (Throwable e) {
                throw new FailedOperationException(this.mainClass.getName() + ".init() method reported an exception", e);
            }
            this.engine.addListener(new EngineListener(){

                public void onConversationCompleted(Conversation conv) {
                    WorkflowApplication.this.ccList.add(conv);
                }
            });
            this.engine.start();
            try {
                this.program.main(this.engine);
            }
            catch (Throwable e) {
                throw new FailedOperationException(this.mainClass.getName() + ".main() method reported an exception", e);
            }
            this.state = WorkflowState.RUNNING;
            logger.info("Started " + this.name);
        }
        finally {
            Thread.currentThread().setContextClassLoader(old);
            if (this.state != WorkflowState.RUNNING) {
                this.program = null;
                if (this.engine.isStarted()) {
                    this.engine.stop();
                }
                this.engine = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Properties loadConfigProperties() throws IOException {
        Properties props = new Properties();
        if (this.confFile.exists()) {
            BufferedInputStream in = new BufferedInputStream(new FileInputStream(this.confFile));
            try {
                props.load(in);
            }
            finally {
                ((InputStream)in).close();
            }
        }
        return props;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveConfigProperties(Properties props) throws IOException {
        this.confFile.getParentFile().mkdirs();
        BufferedOutputStream fos = new BufferedOutputStream(new FileOutputStream(this.confFile));
        try {
            props.store(fos, null);
        }
        finally {
            ((OutputStream)fos).close();
        }
    }

    private static void log(String msg, Throwable t) {
        logger.log(Level.SEVERE, msg, t);
    }

    private ClassLoaderImpl createClassLoader() throws IOException {
        ClassLoaderImpl cl = new ClassLoaderImpl(this.owner.appClassLoader);
        cl.addJarFiles(this.appDir);
        cl.addPathFile(this.appDir);
        cl.makeContinuable();
        return cl;
    }

    @Override
    public synchronized void stop() {
        if (this.state != WorkflowState.RUNNING) {
            return;
        }
        logger.info("Stopping " + this.name);
        if (this.program != null) {
            try {
                this.program.cleanup(this.engine);
            }
            catch (Exception e) {
                WorkflowApplication.log(this.program.getClass().getName() + ".cleanup() method reported an exception", e);
            }
            this.program = null;
        }
        this.engine.stop();
        this.engine = null;
        this.state = WorkflowState.STOPPED;
        logger.info("Stopped " + this.name);
    }

    @Override
    public synchronized void unload() {
        this.stop();
        if (this.state == WorkflowState.UNLOADED) {
            return;
        }
        this.classLoader.cleanup();
        this.classLoader = null;
        this.mainClass = null;
        this.model = null;
        this.state = WorkflowState.UNLOADED;
        logger.info("Unloaded " + this.name);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDescription() {
        if (this.mainClass == null) {
            return "(not available for unloaded workflow)";
        }
        Description d = this.mainClass.getAnnotation(Description.class);
        if (d == null) {
            return "(no description available)";
        }
        return d.value();
    }

    @Override
    public WorkflowState getState() {
        return this.state;
    }

    @Override
    public File getConfigFile() {
        return this.confFile;
    }

    public Engine getEngine() {
        return this.engine;
    }

    public Model<?> getModel() {
        return this.model;
    }

    public Map<Integer, Conversation> getCompletedConversations() {
        return this.ccList.getList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void remove() {
        Object object = this.undeployLock;
        synchronized (object) {
            this.owner.applications.remove(this.getName());
            if (this.objectName != null) {
                try {
                    this.owner.mbeanServer.unregisterMBean(this.objectName);
                }
                catch (JMException e) {
                    logger.log(Level.WARNING, "Failed to unregister " + this.objectName);
                }
                finally {
                    this.objectName = null;
                }
            }
            this.stop();
            this.undeployed = true;
            this.undeployLock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void undeploy() throws FailedOperationException {
        this.unload();
        Object object = this.undeployLock;
        synchronized (object) {
            if (!this.undeployed) {
                File dar = new File(this.owner.appsDir, this.name + ".dar");
                if (dar.exists() && !dar.delete()) {
                    throw new FailedOperationException("failed to delete " + this.appDir);
                }
                try {
                    Util.deleteRecursive((File)this.appDir);
                    Util.deleteRecursive((File)this.workDir);
                }
                catch (IOException e) {
                    throw new FailedOperationException("Unable to clean up the application directory " + this.appDir, e);
                }
                try {
                    this.undeployLock.wait(15000L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                if (!this.undeployed) {
                    throw new FailedOperationException("Operation timed out");
                }
            }
        }
    }
}

