/*
 * Decompiled with CFR 0.152.
 */
package dalma.container.model;

import dalma.container.model.IllegalResourceException;
import dalma.container.model.InjectionException;
import dalma.container.model.Injector;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class MethodInjector<T, V>
extends Injector<T, V> {
    private final Method m;

    public MethodInjector(Method m) throws IllegalResourceException {
        this.m = m;
        if (m.getParameterTypes().length == 0) {
            throw new IllegalResourceException(m.getName() + " has @Resource but takes no parameter");
        }
        if (m.getParameterTypes().length > 1) {
            throw new IllegalResourceException(m.getName() + " has @Resource but takes more than one parameters");
        }
    }

    @Override
    public String getName() {
        String name = this.m.getName();
        if (name.startsWith("set") && name.length() > 3) {
            return Character.toLowerCase(name.charAt(3)) + name.substring(4);
        }
        return name;
    }

    @Override
    public Class<V> _getType() {
        return this.m.getParameterTypes()[0];
    }

    @Override
    public void set(T target, V value) throws InjectionException {
        try {
            this.m.invoke(target, value);
        }
        catch (IllegalAccessException e) {
            throw new InjectionException(e);
        }
        catch (InvocationTargetException e) {
            throw new InjectionException(e);
        }
    }
}

