/*
 * Decompiled with CFR 0.152.
 */
package dalma.container.model;

import dalma.Engine;
import dalma.Resource;
import dalma.container.model.Converter;
import dalma.container.model.FieldInjector;
import dalma.container.model.IllegalResourceException;
import dalma.container.model.InjectionException;
import dalma.container.model.Injector;
import dalma.container.model.MethodInjector;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Model<T> {
    public final Class<T> clazz;
    public final List<Part> parts;

    public Model(Class<T> clazz) throws IllegalResourceException {
        Resource a;
        this.clazz = clazz;
        ArrayList parts = new ArrayList();
        for (Field field : clazz.getFields()) {
            a = field.getAnnotation(Resource.class);
            if (a == null) continue;
            parts.add(new Part(new FieldInjector(field), a));
        }
        for (AccessibleObject accessibleObject : clazz.getMethods()) {
            a = ((Method)accessibleObject).getAnnotation(Resource.class);
            if (a == null) continue;
            parts.add(new Part(new MethodInjector((Method)accessibleObject), a));
        }
        this.parts = Collections.unmodifiableList(parts);
    }

    public void inject(Engine engine, T target, Properties prop) throws InjectionException, ParseException {
        for (Part res : this.parts) {
            res.inject(engine, target, prop);
        }
    }

    public boolean checkConfiguration(Properties props) {
        for (Part res : this.parts) {
            if (res.checkConfiguration(props)) continue;
            return false;
        }
        return true;
    }

    public List<Part> getParts() {
        return this.parts;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public final class Part<V> {
        public final String name;
        public final Class<V> type;
        public final Injector<T, V> injector;
        public final Converter<? super V> converter;
        public final String description;
        public final boolean optional;

        private Part(Injector<T, V> injector, Resource a) throws IllegalResourceException {
            this.injector = injector;
            this.name = injector.getName();
            this.type = injector.getType();
            this.description = a.description();
            this.optional = a.optional();
            this.converter = Converter.get(this.type);
            if (this.converter == null) {
                throw new IllegalResourceException(this.type + " is not supported as a resource type");
            }
        }

        private void inject(Engine engine, T target, Properties prop) throws ParseException, InjectionException {
            String token = prop.getProperty(this.name);
            if (token == null && !this.optional) {
                throw new InjectionException("resource \"" + this.name + "\" must be configured");
            }
            V value = this.converter.load(engine, this.name, token);
            if (!this.type.isInstance(value)) {
                throw new InjectionException("resource \"" + this.name + "\" wants " + this.type.getName() + " but found " + value.getClass().getName() + " in configuration");
            }
            this.injector.set(target, this.type.cast(value));
        }

        public String getName() {
            return this.name;
        }

        public String getDescription() {
            return this.description;
        }

        public boolean checkConfiguration(Properties props) {
            return this.optional || props.getProperty(this.name) != null;
        }
    }
}

