/*
 * Copyright (c) 2007 Mockito contributors
 * This program is made available under the terms of the MIT License.
 */
package org.mockito.internal.stubbing;

import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;

import org.mockito.internal.invocation.Invocation;
import org.mockito.internal.invocation.InvocationMatcher;
import org.mockito.stubbing.Answer;

@SuppressWarnings("unchecked")
public class StubbedInvocationMatcher extends InvocationMatcher {

    private final Queue<Answer> answers = new ConcurrentLinkedQueue<Answer>();

    public StubbedInvocationMatcher(InvocationMatcher invocation, Answer answer) {
        super(invocation.getInvocation(), invocation.getMatchers());
        this.answers.add(answer);
    }

    public Object answer(Invocation invocation) throws Throwable {
        synchronized(answers) {
            return answers.size() == 1 ? answers.peek().answer(invocation) : answers.poll().answer(invocation);
        }
    }

    public void addAnswer(Answer answer) {
        answers.add(answer);
    }

    @Override
    public String toString() {
        return super.toString() + " stubbed with: " + answers;
    }
}