/*
 * Decompiled with CFR 0.152.
 */
package deepwater.datasets;

import deepwater.datasets.ImageDataSet;
import deepwater.datasets.Pair;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;

public class CIFAR10ImageDataset
extends ImageDataSet {
    public CIFAR10ImageDataset() {
        super(32, 32, 3, 10);
    }

    @Override
    public List<Pair<Integer, float[]>> loadImages(String ... filepath) throws IOException {
        ArrayList<Pair<Integer, float[]>> images = new ArrayList<Pair<Integer, float[]>>();
        FileInputStream inputStream = new FileInputStream(filepath[0]);
        int read = 0;
        byte[] buffer = new byte[3073];
        while ((read = ((InputStream)inputStream).read(buffer, 0, buffer.length)) != -1) {
            int label = buffer[0] % 255;
            float[] imageDataFloat = new float[3072];
            int i = 0;
            for (int j = 1; j < imageDataFloat.length; ++j) {
                float result = buffer[j] & 0xFF;
                imageDataFloat[i++] = result;
            }
            images.add(new Pair<Integer, float[]>(label, imageDataFloat));
        }
        return images;
    }
}

