/*
 * Decompiled with CFR 0.152.
 */
package net.incongru.berkano.tree;

import java.io.IOException;
import java.io.Writer;
import net.incongru.berkano.tree.Tree;
import net.incongru.berkano.tree.TreeIterator;
import net.incongru.berkano.tree.TreeNode;
import net.incongru.berkano.tree.TreeWriter;

public class SimpleTreeWriter
implements TreeWriter {
    private int indent;

    public SimpleTreeWriter() {
        this(2);
    }

    public SimpleTreeWriter(int indent) {
        this.indent = indent;
    }

    public void write(Tree tree, Writer out) throws IOException {
        TreeIterator it = tree.getTreeIterator();
        this.iterateNode(it, out, 0);
    }

    private void iterateNode(TreeIterator it, Writer out, int level) throws IOException {
        while (it.hasNext()) {
            TreeNode node = (TreeNode)it.next();
            Object nodeObject = node.getObject();
            this.writeNode(nodeObject, out, level);
            if (!node.isOpen() || !it.hasChildren()) continue;
            this.iterateNode(it.getChildIterator(), out, level + 1);
        }
    }

    protected void writeNode(Object nodeObject, Writer out, int level) throws IOException {
        this.indent(out, level);
        if (nodeObject != null) {
            this.writeObject(nodeObject, out);
        }
        out.write(10);
    }

    protected void writeObject(Object nodeObject, Writer out) throws IOException {
        out.write(nodeObject.toString());
    }

    protected void indent(Writer out, int level) throws IOException {
        for (int i = 0; i < level * this.indent; ++i) {
            out.write(32);
        }
    }
}

