/*
 * Decompiled with CFR 0.152.
 */
package net.incongru.berkano.tree;

import java.io.Serializable;
import java.util.List;
import net.incongru.berkano.tree.TreeIterator;
import net.incongru.berkano.tree.TreeNode;

public class Tree
implements Serializable {
    private TreeNode root;

    public Tree() {
        this(new TreeNode(null));
    }

    Tree(TreeNode root) {
        this.root = root;
    }

    public void addObject(Object object, Object parentObject) {
        TreeNode parentNode = this.root.findNodeOf(parentObject);
        this.addObject(object, parentNode);
    }

    public void addNode(TreeNode newNode, Object parentObject) {
        TreeNode parentNode = this.root.findNodeOf(parentObject);
        parentNode.addChild(newNode);
    }

    TreeNode addObject(Object object, TreeNode parentNode) {
        TreeNode newNode = new TreeNode(object);
        if (parentNode == null) {
            parentNode = this.root;
        }
        parentNode.addChild(newNode);
        return newNode;
    }

    public TreeNode removeObject(Object object) {
        TreeNode parentNode = this.root.findParentOf(object);
        if (parentNode == null) {
            throw new RuntimeException("Can't find parent node for " + object);
        }
        return parentNode.removeChild(object);
    }

    public void changeOrder(Object object, boolean up) {
        TreeNode parentNode = this.root.findParentOf(object);
        if (parentNode == null) {
            throw new RuntimeException("Can't find parent node for " + object);
        }
        TreeNode objNode = parentNode.findNodeOf(object);
        if (objNode == null) {
            throw new RuntimeException("Can't find node for " + object);
        }
        List childNodes = parentNode.getChildren();
        int currentIndex = childNodes.indexOf(objNode);
        if (currentIndex == 0 && up || !up && currentIndex == childNodes.size() - 1) {
            throw new IllegalStateException("Node " + object + " can't be moved");
        }
        childNodes.remove(currentIndex);
        int newIndex = up ? currentIndex - 1 : currentIndex + 1;
        childNodes.add(newIndex, objNode);
    }

    public TreeIterator getTreeIterator() {
        return new TreeIterator(this.root);
    }
}

