/*
 * Decompiled with CFR 0.152.
 */
package net.incongru.berkano.tree;

import java.util.Iterator;
import net.incongru.berkano.tree.TreeNode;

public class TreeIterator
implements Iterator {
    private Iterator nodeIterator;
    private TreeNode lastRetrievedNode;

    public TreeIterator(TreeNode node) {
        this.nodeIterator = node.getChildren().iterator();
    }

    public boolean hasNext() {
        return this.nodeIterator.hasNext();
    }

    public Object next() {
        this.lastRetrievedNode = (TreeNode)this.nodeIterator.next();
        return this.lastRetrievedNode;
    }

    public boolean hasChildren() {
        if (this.lastRetrievedNode == null) {
            throw new IllegalStateException("Can't call hasChildren() before having called next()");
        }
        return this.lastRetrievedNode.getChildren().size() > 0;
    }

    public TreeIterator getChildIterator() {
        if (this.lastRetrievedNode == null) {
            throw new IllegalStateException("Can't call hasChildren() before having called next()");
        }
        return new TreeIterator(this.lastRetrievedNode);
    }

    public void remove() {
        throw new UnsupportedOperationException("Remove is not supported in this implementation");
    }
}

