/*
 * Decompiled with CFR 0.152.
 */
package net.incongru.berkano.tree;

import java.io.Serializable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class TreeNode
implements Serializable {
    private List children = new LinkedList();
    private Object object;
    private boolean isOpen;

    TreeNode(Object object) {
        this.object = object;
        this.isOpen = true;
    }

    List getChildren() {
        return this.children;
    }

    Object getObject() {
        return this.object;
    }

    boolean isOpen() {
        return this.isOpen;
    }

    void setIsOpen(boolean isOpen) {
        this.isOpen = isOpen;
    }

    void addChild(TreeNode childNode) {
        if (childNode == this) {
            throw new IllegalArgumentException("Can't add a node to itself");
        }
        this.children.add(childNode);
    }

    TreeNode findParentOf(Object o) {
        return this.findNodeOf(o, true);
    }

    TreeNode findNodeOf(Object o) {
        return this.findNodeOf(o, false);
    }

    private TreeNode findNodeOf(Object o, boolean returnParent) {
        for (TreeNode childNode : this.children) {
            if (childNode.getObject() != null && childNode.getObject().equals(o)) {
                return returnParent ? this : childNode;
            }
            if (o == null && childNode.getObject() == null) {
                return returnParent ? this : childNode;
            }
            TreeNode foundInChild = childNode.findNodeOf(o, returnParent);
            if (foundInChild == null) continue;
            return foundInChild;
        }
        return null;
    }

    TreeNode removeChild(Object objectToRemoveFromChildren) {
        Iterator it = this.children.iterator();
        while (it.hasNext()) {
            TreeNode treeNode = (TreeNode)it.next();
            if (treeNode.getObject() != objectToRemoveFromChildren) continue;
            it.remove();
            return treeNode;
        }
        return null;
    }
}

