/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.batch.config;

import javax.annotation.PostConstruct;
import org.springframework.batch.core.configuration.annotation.BatchConfigurer;
import org.springframework.batch.core.explore.JobExplorer;
import org.springframework.batch.core.explore.support.MapJobExplorerFactoryBean;
import org.springframework.batch.core.launch.JobLauncher;
import org.springframework.batch.core.launch.support.SimpleJobLauncher;
import org.springframework.batch.core.repository.JobRepository;
import org.springframework.batch.core.repository.support.MapJobRepositoryFactoryBean;
import org.springframework.batch.support.transaction.ResourcelessTransactionManager;
import org.springframework.context.annotation.Configuration;
import org.springframework.stereotype.Component;
import org.springframework.transaction.PlatformTransactionManager;

@Component
@Configuration
public class InMemoryJobRepositoryBatchConfig
implements BatchConfigurer {
    private PlatformTransactionManager myPlatformTransactionManager;
    private JobLauncher myJobLauncher;
    private JobRepository myJobRepository;
    private JobExplorer myJobExplorer;

    public PlatformTransactionManager getTransactionManager() {
        return this.myPlatformTransactionManager;
    }

    public JobRepository getJobRepository() {
        return this.myJobRepository;
    }

    public JobLauncher getJobLauncher() {
        return this.myJobLauncher;
    }

    public JobExplorer getJobExplorer() {
        return this.myJobExplorer;
    }

    @PostConstruct
    public void setup() throws Exception {
        if (this.myPlatformTransactionManager == null) {
            this.myPlatformTransactionManager = new ResourcelessTransactionManager();
        }
        MapJobRepositoryFactoryBean jobRepositoryFactoryBean = new MapJobRepositoryFactoryBean(this.myPlatformTransactionManager);
        jobRepositoryFactoryBean.afterPropertiesSet();
        this.myJobRepository = jobRepositoryFactoryBean.getObject();
        MapJobExplorerFactoryBean jobExplorerFactoryBean = new MapJobExplorerFactoryBean(jobRepositoryFactoryBean);
        jobExplorerFactoryBean.afterPropertiesSet();
        this.myJobExplorer = jobExplorerFactoryBean.getObject();
        SimpleJobLauncher jobLauncher = new SimpleJobLauncher();
        jobLauncher.setJobRepository(this.myJobRepository);
        jobLauncher.afterPropertiesSet();
        this.myJobLauncher = jobLauncher;
    }
}

