/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.model.entity;

import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.jpa.model.entity.BaseTag;
import ca.uhn.fhir.jpa.model.entity.ForcedId;
import ca.uhn.fhir.jpa.model.entity.IBaseResourceEntity;
import ca.uhn.fhir.jpa.model.entity.TagDefinition;
import ca.uhn.fhir.model.primitive.IdDt;
import ca.uhn.fhir.model.primitive.InstantDt;
import java.util.Collection;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.MappedSuperclass;
import javax.persistence.OneToOne;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import org.hibernate.annotations.OptimisticLock;

@MappedSuperclass
public abstract class BaseHasResource
implements IBaseResourceEntity {
    @Column(name="RES_DELETED_AT", nullable=true)
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date myDeleted;
    @Column(name="RES_VERSION", nullable=true, length=7)
    @Enumerated(value=EnumType.STRING)
    @OptimisticLock(excluded=true)
    private FhirVersionEnum myFhirVersion;
    @OneToOne(optional=true, fetch=FetchType.LAZY, cascade={}, orphanRemoval=false)
    @JoinColumn(name="FORCED_ID_PID")
    @OptimisticLock(excluded=true)
    private ForcedId myForcedId;
    @Column(name="HAS_TAGS", nullable=false)
    @OptimisticLock(excluded=true)
    private boolean myHasTags;
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="RES_PUBLISHED", nullable=false)
    @OptimisticLock(excluded=true)
    private Date myPublished;
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="RES_UPDATED", nullable=false)
    @OptimisticLock(excluded=true)
    private Date myUpdated;

    public abstract BaseTag addTag(TagDefinition var1);

    @Override
    public Date getDeleted() {
        return this.myDeleted;
    }

    public void setDeleted(Date theDate) {
        this.myDeleted = theDate;
    }

    @Override
    public FhirVersionEnum getFhirVersion() {
        return this.myFhirVersion;
    }

    public void setFhirVersion(FhirVersionEnum theFhirVersion) {
        this.myFhirVersion = theFhirVersion;
    }

    public ForcedId getForcedId() {
        return this.myForcedId;
    }

    public void setForcedId(ForcedId theForcedId) {
        this.myForcedId = theForcedId;
    }

    @Override
    public abstract Long getId();

    @Override
    public abstract IdDt getIdDt();

    @Override
    public InstantDt getPublished() {
        if (this.myPublished != null) {
            return new InstantDt(this.myPublished);
        }
        return null;
    }

    public void setPublished(Date thePublished) {
        this.myPublished = thePublished;
    }

    @Override
    public abstract Long getResourceId();

    @Override
    public abstract String getResourceType();

    public abstract Collection<? extends BaseTag> getTags();

    @Override
    public InstantDt getUpdated() {
        return new InstantDt(this.myUpdated);
    }

    public void setUpdated(Date theUpdated) {
        this.myUpdated = theUpdated;
    }

    @Override
    public Date getUpdatedDate() {
        return this.myUpdated;
    }

    @Override
    public abstract long getVersion();

    @Override
    public boolean isHasTags() {
        return this.myHasTags;
    }

    public void setHasTags(boolean theHasTags) {
        this.myHasTags = theHasTags;
    }

    public void setPublished(InstantDt thePublished) {
        this.myPublished = (Date)thePublished.getValue();
    }

    public void setUpdated(InstantDt theUpdated) {
        this.myUpdated = (Date)theUpdated.getValue();
    }
}

