/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.model.entity;

import ca.uhn.fhir.jpa.model.entity.BaseResourceIndex;
import ca.uhn.fhir.jpa.model.entity.ResourceTable;
import ca.uhn.fhir.model.api.IQueryParameterType;
import ca.uhn.fhir.util.UrlUtil;
import com.google.common.base.Charsets;
import com.google.common.hash.HashCode;
import com.google.common.hash.HashFunction;
import com.google.common.hash.Hasher;
import com.google.common.hash.Hashing;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.MappedSuperclass;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import org.hibernate.search.annotations.ContainedIn;
import org.hibernate.search.annotations.Field;

@MappedSuperclass
public abstract class BaseResourceIndexedSearchParam
extends BaseResourceIndex {
    static final int MAX_SP_NAME = 100;
    private static final HashFunction HASH_FUNCTION = Hashing.murmur3_128((int)0);
    private static final byte[] DELIMITER_BYTES = "|".getBytes(Charsets.UTF_8);
    private static final long serialVersionUID = 1L;
    @Field
    @Column(name="SP_MISSING", nullable=true)
    private Boolean myMissing = Boolean.FALSE;
    @Field
    @Column(name="SP_NAME", length=100, nullable=false)
    private String myParamName;
    @ManyToOne(optional=false, fetch=FetchType.LAZY)
    @JoinColumn(name="RES_ID", referencedColumnName="RES_ID")
    @ContainedIn
    private ResourceTable myResource;
    @Column(name="RES_ID", insertable=false, updatable=false)
    private Long myResourcePid;
    @Field
    @Column(name="RES_TYPE", nullable=false)
    private String myResourceType;
    @Field
    @Column(name="SP_UPDATED", nullable=true)
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date myUpdated;

    protected void clearHashes() {
    }

    @Override
    public abstract Long getId();

    public String getParamName() {
        return this.myParamName;
    }

    public void setParamName(String theName) {
        this.clearHashes();
        this.myParamName = theName;
    }

    public ResourceTable getResource() {
        return this.myResource;
    }

    public BaseResourceIndexedSearchParam setResource(ResourceTable theResource) {
        this.clearHashes();
        this.myResource = theResource;
        this.myResourceType = theResource.getResourceType();
        return this;
    }

    public Long getResourcePid() {
        return this.myResourcePid;
    }

    public String getResourceType() {
        return this.myResourceType;
    }

    public Date getUpdated() {
        return this.myUpdated;
    }

    public void setUpdated(Date theUpdated) {
        this.myUpdated = theUpdated;
    }

    public boolean isMissing() {
        return Boolean.TRUE.equals(this.myMissing);
    }

    public BaseResourceIndexedSearchParam setMissing(boolean theMissing) {
        this.myMissing = theMissing;
        return this;
    }

    public abstract IQueryParameterType toQueryParameterType();

    public static long calculateHashIdentity(String theResourceType, String theParamName) {
        return BaseResourceIndexedSearchParam.hash(theResourceType, theParamName);
    }

    static long hash(String ... theValues) {
        Hasher hasher = HASH_FUNCTION.newHasher();
        for (String next : theValues) {
            if (next == null) {
                hasher.putByte((byte)0);
            } else {
                next = UrlUtil.escapeUrlParam((String)next);
                byte[] bytes = next.getBytes(Charsets.UTF_8);
                hasher.putBytes(bytes);
            }
            hasher.putBytes(DELIMITER_BYTES);
        }
        HashCode hashCode = hasher.hash();
        return hashCode.asLong();
    }

    public boolean matches(IQueryParameterType theParam) {
        throw new UnsupportedOperationException("No parameter matcher for " + theParam);
    }
}

