/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.model.entity;

import com.google.common.annotations.VisibleForTesting;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.Validate;
import org.hl7.fhir.instance.model.Subscription;

public class ModelConfig {
    public static final Set<String> DEFAULT_LOGICAL_BASE_URLS = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("http://hl7.org/fhir/ValueSet/*", "http://hl7.org/fhir/CodeSystem/*", "http://hl7.org/fhir/valueset-*", "http://hl7.org/fhir/codesystem-*", "http://hl7.org/fhir/StructureDefinition/*")));
    private boolean myAllowContainsSearches = false;
    private boolean myAllowExternalReferences = false;
    private Set<String> myTreatBaseUrlsAsLocal = new HashSet<String>();
    private Set<String> myTreatReferencesAsLogical = new HashSet<String>(DEFAULT_LOGICAL_BASE_URLS);
    private boolean myDefaultSearchParamsCanBeOverridden = false;
    private Set<Subscription.SubscriptionChannelType> mySupportedSubscriptionTypes = new HashSet<Subscription.SubscriptionChannelType>();
    private String myEmailFromAddress = "noreply@unknown.com";
    private boolean mySubscriptionMatchingEnabled = true;

    public boolean isDefaultSearchParamsCanBeOverridden() {
        return this.myDefaultSearchParamsCanBeOverridden;
    }

    public void setDefaultSearchParamsCanBeOverridden(boolean theDefaultSearchParamsCanBeOverridden) {
        this.myDefaultSearchParamsCanBeOverridden = theDefaultSearchParamsCanBeOverridden;
    }

    public boolean isAllowContainsSearches() {
        return this.myAllowContainsSearches;
    }

    public void setAllowContainsSearches(boolean theAllowContainsSearches) {
        this.myAllowContainsSearches = theAllowContainsSearches;
    }

    public boolean isAllowExternalReferences() {
        return this.myAllowExternalReferences;
    }

    public void setAllowExternalReferences(boolean theAllowExternalReferences) {
        this.myAllowExternalReferences = theAllowExternalReferences;
    }

    public Set<String> getTreatBaseUrlsAsLocal() {
        return this.myTreatBaseUrlsAsLocal;
    }

    public void setTreatBaseUrlsAsLocal(Set<String> theTreatBaseUrlsAsLocal) {
        if (theTreatBaseUrlsAsLocal != null) {
            for (String next : theTreatBaseUrlsAsLocal) {
                ModelConfig.validateTreatBaseUrlsAsLocal(next);
            }
        }
        HashSet<String> treatBaseUrlsAsLocal = new HashSet<String>();
        for (String next : (Set)ObjectUtils.defaultIfNull(theTreatBaseUrlsAsLocal, new HashSet())) {
            while (next.endsWith("/")) {
                next = next.substring(0, next.length() - 1);
            }
            treatBaseUrlsAsLocal.add(next);
        }
        this.myTreatBaseUrlsAsLocal = treatBaseUrlsAsLocal;
    }

    public void addTreatReferencesAsLogical(String theTreatReferencesAsLogical) {
        ModelConfig.validateTreatBaseUrlsAsLocal(theTreatReferencesAsLogical);
        if (this.myTreatReferencesAsLogical == null) {
            this.myTreatReferencesAsLogical = new HashSet<String>();
        }
        this.myTreatReferencesAsLogical.add(theTreatReferencesAsLogical);
    }

    public Set<String> getTreatReferencesAsLogical() {
        return this.myTreatReferencesAsLogical;
    }

    public ModelConfig setTreatReferencesAsLogical(Set<String> theTreatReferencesAsLogical) {
        this.myTreatReferencesAsLogical = theTreatReferencesAsLogical;
        return this;
    }

    public ModelConfig addSupportedSubscriptionType(Subscription.SubscriptionChannelType theSubscriptionChannelType) {
        this.mySupportedSubscriptionTypes.add(theSubscriptionChannelType);
        return this;
    }

    public Set<Subscription.SubscriptionChannelType> getSupportedSubscriptionTypes() {
        return Collections.unmodifiableSet(this.mySupportedSubscriptionTypes);
    }

    public boolean isSubscriptionMatchingEnabled() {
        return this.mySubscriptionMatchingEnabled;
    }

    public void setSubscriptionMatchingEnabled(boolean theSubscriptionMatchingEnabled) {
        this.mySubscriptionMatchingEnabled = theSubscriptionMatchingEnabled;
    }

    @VisibleForTesting
    public void clearSupportedSubscriptionTypesForUnitTest() {
        this.mySupportedSubscriptionTypes.clear();
    }

    public String getEmailFromAddress() {
        return this.myEmailFromAddress;
    }

    public void setEmailFromAddress(String theEmailFromAddress) {
        this.myEmailFromAddress = theEmailFromAddress;
    }

    private static void validateTreatBaseUrlsAsLocal(String theUrl) {
        Validate.notBlank((CharSequence)theUrl, (String)"Base URL must not be null or empty", (Object[])new Object[0]);
        int starIdx = theUrl.indexOf(42);
        if (starIdx != -1 && starIdx != theUrl.length() - 1) {
            throw new IllegalArgumentException("Base URL wildcard character (*) can only appear at the end of the string: " + theUrl);
        }
    }
}

