/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.model.entity;

import ca.uhn.fhir.jpa.model.entity.BaseHasResource;
import ca.uhn.fhir.jpa.model.entity.ResourceEncodingEnum;
import ca.uhn.fhir.jpa.model.entity.ResourceHistoryTag;
import ca.uhn.fhir.jpa.model.entity.ResourceTag;
import ca.uhn.fhir.jpa.model.entity.TagDefinition;
import ca.uhn.fhir.model.primitive.IdDt;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.Lob;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.UniqueConstraint;
import org.hibernate.annotations.OptimisticLock;

@Entity
@Table(name="HFJ_RES_VER", uniqueConstraints={@UniqueConstraint(name="IDX_RESVER_ID_VER", columnNames={"RES_ID", "RES_VER"})}, indexes={@Index(name="IDX_RESVER_TYPE_DATE", columnList="RES_TYPE,RES_UPDATED"), @Index(name="IDX_RESVER_ID_DATE", columnList="RES_ID,RES_UPDATED"), @Index(name="IDX_RESVER_DATE", columnList="RES_UPDATED")})
public class ResourceHistoryTable
extends BaseHasResource
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String IDX_RESVER_ID_VER = "IDX_RESVER_ID_VER";
    public static final int ENCODING_COL_LENGTH = 5;
    @Id
    @SequenceGenerator(name="SEQ_RESOURCE_HISTORY_ID", sequenceName="SEQ_RESOURCE_HISTORY_ID")
    @GeneratedValue(strategy=GenerationType.AUTO, generator="SEQ_RESOURCE_HISTORY_ID")
    @Column(name="PID")
    private Long myId;
    @Column(name="RES_ID")
    private Long myResourceId;
    @Column(name="RES_TYPE", length=30, nullable=false)
    private String myResourceType;
    @Column(name="RES_VER", nullable=false)
    private Long myResourceVersion;
    @OneToMany(mappedBy="myResourceHistory", cascade={CascadeType.ALL}, fetch=FetchType.LAZY, orphanRemoval=true)
    private Collection<ResourceHistoryTag> myTags;
    @Column(name="RES_TEXT", length=0x7FFFFFFE, nullable=true)
    @Lob
    @OptimisticLock(excluded=true)
    private byte[] myResource;
    @Column(name="RES_ENCODING", nullable=false, length=5)
    @Enumerated(value=EnumType.STRING)
    @OptimisticLock(excluded=true)
    private ResourceEncodingEnum myEncoding;

    public void addTag(ResourceHistoryTag theTag) {
        for (ResourceHistoryTag next : this.getTags()) {
            if (!next.getTag().equals(theTag)) continue;
            return;
        }
        this.getTags().add(theTag);
    }

    public void addTag(ResourceTag theTag) {
        ResourceHistoryTag tag = new ResourceHistoryTag(this, theTag.getTag());
        tag.setResourceType(theTag.getResourceType());
        this.getTags().add(tag);
    }

    @Override
    public ResourceHistoryTag addTag(TagDefinition theTag) {
        for (ResourceHistoryTag next : this.getTags()) {
            if (!next.getTag().equals(theTag)) continue;
            return next;
        }
        ResourceHistoryTag historyTag = new ResourceHistoryTag(this, theTag);
        this.getTags().add(historyTag);
        return historyTag;
    }

    public ResourceEncodingEnum getEncoding() {
        return this.myEncoding;
    }

    public void setEncoding(ResourceEncodingEnum theEncoding) {
        this.myEncoding = theEncoding;
    }

    @Override
    public Long getId() {
        return this.myId;
    }

    public void setId(Long theId) {
        this.myId = theId;
    }

    @Override
    public IdDt getIdDt() {
        if (this.getForcedId() == null) {
            Long id = this.myResourceId;
            return new IdDt(this.myResourceType + '/' + id + '/' + "_history" + '/' + this.getVersion());
        }
        return new IdDt(this.getForcedId().getResourceType() + '/' + this.getForcedId().getForcedId() + '/' + "_history" + '/' + this.getVersion());
    }

    public byte[] getResource() {
        return this.myResource;
    }

    public void setResource(byte[] theResource) {
        this.myResource = theResource;
    }

    @Override
    public Long getResourceId() {
        return this.myResourceId;
    }

    public void setResourceId(Long theResourceId) {
        this.myResourceId = theResourceId;
    }

    @Override
    public String getResourceType() {
        return this.myResourceType;
    }

    public void setResourceType(String theResourceType) {
        this.myResourceType = theResourceType;
    }

    public Collection<ResourceHistoryTag> getTags() {
        if (this.myTags == null) {
            this.myTags = new ArrayList<ResourceHistoryTag>();
        }
        return this.myTags;
    }

    @Override
    public long getVersion() {
        return this.myResourceVersion;
    }

    public void setVersion(long theVersion) {
        this.myResourceVersion = theVersion;
    }

    public boolean hasTag(String theTerm, String theScheme) {
        for (ResourceHistoryTag next : this.getTags()) {
            if (!next.getTag().getSystem().equals(theScheme) || !next.getTag().getCode().equals(theTerm)) continue;
            return true;
        }
        return false;
    }
}

