/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.model.entity;

import ca.uhn.fhir.jpa.model.entity.BaseResourceIndexedSearchParam;
import ca.uhn.fhir.model.api.IQueryParameterType;
import javax.persistence.Column;
import javax.persistence.Embeddable;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.PrePersist;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.hibernate.search.annotations.Field;

@Embeddable
@Entity
@Table(name="HFJ_SPIDX_COORDS", indexes={@Index(name="IDX_SP_COORDS_HASH", columnList="HASH_IDENTITY,SP_LATITUDE,SP_LONGITUDE"), @Index(name="IDX_SP_COORDS_UPDATED", columnList="SP_UPDATED"), @Index(name="IDX_SP_COORDS_RESID", columnList="RES_ID")})
public class ResourceIndexedSearchParamCoords
extends BaseResourceIndexedSearchParam {
    public static final int MAX_LENGTH = 100;
    private static final long serialVersionUID = 1L;
    @Column(name="SP_LATITUDE")
    @Field
    public double myLatitude;
    @Column(name="SP_LONGITUDE")
    @Field
    public double myLongitude;
    @Id
    @SequenceGenerator(name="SEQ_SPIDX_COORDS", sequenceName="SEQ_SPIDX_COORDS")
    @GeneratedValue(strategy=GenerationType.AUTO, generator="SEQ_SPIDX_COORDS")
    @Column(name="SP_ID")
    private Long myId;
    @Column(name="HASH_IDENTITY", nullable=true)
    private Long myHashIdentity;

    public ResourceIndexedSearchParamCoords() {
    }

    public ResourceIndexedSearchParamCoords(String theName, double theLatitude, double theLongitude) {
        this.setParamName(theName);
        this.setLatitude(theLatitude);
        this.setLongitude(theLongitude);
    }

    @Override
    @PrePersist
    public void calculateHashes() {
        if (this.myHashIdentity == null) {
            String resourceType = this.getResourceType();
            String paramName = this.getParamName();
            this.setHashIdentity(ResourceIndexedSearchParamCoords.calculateHashIdentity(resourceType, paramName));
        }
    }

    @Override
    protected void clearHashes() {
        this.myHashIdentity = null;
    }

    @Override
    public boolean equals(Object theObj) {
        if (this == theObj) {
            return true;
        }
        if (theObj == null) {
            return false;
        }
        if (!(theObj instanceof ResourceIndexedSearchParamCoords)) {
            return false;
        }
        ResourceIndexedSearchParamCoords obj = (ResourceIndexedSearchParamCoords)theObj;
        EqualsBuilder b = new EqualsBuilder();
        b.append((Object)this.getParamName(), (Object)obj.getParamName());
        b.append((Object)this.getResource(), (Object)obj.getResource());
        b.append(this.getLatitude(), obj.getLatitude());
        b.append(this.getLongitude(), obj.getLongitude());
        b.append((Object)this.getHashIdentity(), (Object)obj.getHashIdentity());
        return b.isEquals();
    }

    public Long getHashIdentity() {
        this.calculateHashes();
        return this.myHashIdentity;
    }

    public void setHashIdentity(Long theHashIdentity) {
        this.myHashIdentity = theHashIdentity;
    }

    @Override
    public Long getId() {
        return this.myId;
    }

    @Override
    public void setId(Long theId) {
        this.myId = theId;
    }

    public double getLatitude() {
        return this.myLatitude;
    }

    public void setLatitude(double theLatitude) {
        this.myLatitude = theLatitude;
    }

    public double getLongitude() {
        return this.myLongitude;
    }

    public void setLongitude(double theLongitude) {
        this.myLongitude = theLongitude;
    }

    @Override
    public int hashCode() {
        HashCodeBuilder b = new HashCodeBuilder();
        b.append((Object)this.getParamName());
        b.append((Object)this.getResource());
        b.append(this.getLatitude());
        b.append(this.getLongitude());
        return b.toHashCode();
    }

    @Override
    public IQueryParameterType toQueryParameterType() {
        return null;
    }

    public String toString() {
        ToStringBuilder b = new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE);
        b.append("paramName", (Object)this.getParamName());
        b.append("resourceId", (Object)this.getResourcePid());
        b.append("lat", this.getLatitude());
        b.append("lon", this.getLongitude());
        return b.build();
    }
}

