/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.model.entity;

import ca.uhn.fhir.jpa.model.entity.BaseResourceIndexedSearchParam;
import ca.uhn.fhir.model.api.IQueryParameterType;
import ca.uhn.fhir.model.api.TemporalPrecisionEnum;
import ca.uhn.fhir.model.primitive.InstantDt;
import ca.uhn.fhir.rest.param.DateParam;
import ca.uhn.fhir.rest.param.DateRangeParam;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Embeddable;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.PrePersist;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.hibernate.search.annotations.Field;
import org.hl7.fhir.r4.model.DateTimeType;

@Embeddable
@Entity
@Table(name="HFJ_SPIDX_DATE", indexes={@Index(name="IDX_SP_DATE_HASH", columnList="HASH_IDENTITY,SP_VALUE_LOW,SP_VALUE_HIGH"), @Index(name="IDX_SP_DATE_UPDATED", columnList="SP_UPDATED"), @Index(name="IDX_SP_DATE_RESID", columnList="RES_ID")})
public class ResourceIndexedSearchParamDate
extends BaseResourceIndexedSearchParam {
    private static final long serialVersionUID = 1L;
    @Column(name="SP_VALUE_HIGH", nullable=true)
    @Temporal(value=TemporalType.TIMESTAMP)
    @Field
    public Date myValueHigh;
    @Column(name="SP_VALUE_LOW", nullable=true)
    @Temporal(value=TemporalType.TIMESTAMP)
    @Field
    public Date myValueLow;
    @Transient
    private transient String myOriginalValue;
    @Id
    @SequenceGenerator(name="SEQ_SPIDX_DATE", sequenceName="SEQ_SPIDX_DATE")
    @GeneratedValue(strategy=GenerationType.AUTO, generator="SEQ_SPIDX_DATE")
    @Column(name="SP_ID")
    private Long myId;
    @Column(name="HASH_IDENTITY", nullable=true)
    private Long myHashIdentity;

    public ResourceIndexedSearchParamDate() {
    }

    public ResourceIndexedSearchParamDate(String theName, Date theLow, Date theHigh, String theOriginalValue) {
        this.setParamName(theName);
        this.setValueLow(theLow);
        this.setValueHigh(theHigh);
        this.myOriginalValue = theOriginalValue;
    }

    @Override
    @PrePersist
    public void calculateHashes() {
        if (this.myHashIdentity == null) {
            String resourceType = this.getResourceType();
            String paramName = this.getParamName();
            this.setHashIdentity(ResourceIndexedSearchParamDate.calculateHashIdentity(resourceType, paramName));
        }
    }

    @Override
    protected void clearHashes() {
        this.myHashIdentity = null;
    }

    @Override
    public boolean equals(Object theObj) {
        if (this == theObj) {
            return true;
        }
        if (theObj == null) {
            return false;
        }
        if (!(theObj instanceof ResourceIndexedSearchParamDate)) {
            return false;
        }
        ResourceIndexedSearchParamDate obj = (ResourceIndexedSearchParamDate)theObj;
        EqualsBuilder b = new EqualsBuilder();
        b.append((Object)this.getParamName(), (Object)obj.getParamName());
        b.append((Object)this.getResource(), (Object)obj.getResource());
        b.append((Object)this.getTimeFromDate(this.getValueHigh()), (Object)this.getTimeFromDate(obj.getValueHigh()));
        b.append((Object)this.getTimeFromDate(this.getValueLow()), (Object)this.getTimeFromDate(obj.getValueLow()));
        b.append((Object)this.getHashIdentity(), (Object)obj.getHashIdentity());
        return b.isEquals();
    }

    public Long getHashIdentity() {
        this.calculateHashes();
        return this.myHashIdentity;
    }

    public void setHashIdentity(Long theHashIdentity) {
        this.myHashIdentity = theHashIdentity;
    }

    @Override
    public Long getId() {
        return this.myId;
    }

    @Override
    public void setId(Long theId) {
        this.myId = theId;
    }

    protected Long getTimeFromDate(Date date) {
        if (date != null) {
            return date.getTime();
        }
        return null;
    }

    public Date getValueHigh() {
        return this.myValueHigh;
    }

    public void setValueHigh(Date theValueHigh) {
        this.myValueHigh = theValueHigh;
    }

    public Date getValueLow() {
        return this.myValueLow;
    }

    public void setValueLow(Date theValueLow) {
        this.myValueLow = theValueLow;
    }

    @Override
    public int hashCode() {
        HashCodeBuilder b = new HashCodeBuilder();
        b.append((Object)this.getParamName());
        b.append((Object)this.getResource());
        b.append((Object)this.getTimeFromDate(this.getValueHigh()));
        b.append((Object)this.getTimeFromDate(this.getValueLow()));
        return b.toHashCode();
    }

    @Override
    public IQueryParameterType toQueryParameterType() {
        DateTimeType value = new DateTimeType(this.myOriginalValue);
        if (value.getPrecision().ordinal() > TemporalPrecisionEnum.DAY.ordinal()) {
            value.setTimeZoneZulu(true);
        }
        return new DateParam(value.getValueAsString());
    }

    public String toString() {
        ToStringBuilder b = new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE);
        b.append("paramName", (Object)this.getParamName());
        b.append("resourceId", (Object)this.getResource().getId());
        b.append("valueLow", (Object)new InstantDt(this.getValueLow()));
        b.append("valueHigh", (Object)new InstantDt(this.getValueHigh()));
        return b.build();
    }

    @Override
    public boolean matches(IQueryParameterType theParam) {
        if (!(theParam instanceof DateParam)) {
            return false;
        }
        DateParam date = (DateParam)theParam;
        DateRangeParam range = new DateRangeParam(date);
        Date lowerBound = range.getLowerBoundAsInstant();
        Date upperBound = range.getUpperBoundAsInstant();
        if (lowerBound == null && upperBound == null) {
            return false;
        }
        boolean result = true;
        if (lowerBound != null) {
            result &= this.myValueLow.after(lowerBound) || this.myValueLow.equals(lowerBound);
            result &= this.myValueHigh.after(lowerBound) || this.myValueHigh.equals(lowerBound);
        }
        if (upperBound != null) {
            result &= this.myValueLow.before(upperBound) || this.myValueLow.equals(upperBound);
            result &= this.myValueHigh.before(upperBound) || this.myValueHigh.equals(upperBound);
        }
        return result;
    }
}

