/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.model.entity;

import ca.uhn.fhir.jpa.model.entity.BaseResourceIndexedSearchParam;
import ca.uhn.fhir.jpa.model.util.BigDecimalNumericFieldBridge;
import ca.uhn.fhir.model.api.IQueryParameterType;
import ca.uhn.fhir.rest.param.NumberParam;
import java.math.BigDecimal;
import javax.persistence.Column;
import javax.persistence.Embeddable;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.PrePersist;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.FieldBridge;
import org.hibernate.search.annotations.NumericField;

@Embeddable
@Entity
@Table(name="HFJ_SPIDX_NUMBER", indexes={@Index(name="IDX_SP_NUMBER_HASH_VAL", columnList="HASH_IDENTITY,SP_VALUE"), @Index(name="IDX_SP_NUMBER_UPDATED", columnList="SP_UPDATED"), @Index(name="IDX_SP_NUMBER_RESID", columnList="RES_ID")})
public class ResourceIndexedSearchParamNumber
extends BaseResourceIndexedSearchParam {
    private static final long serialVersionUID = 1L;
    @Column(name="SP_VALUE", nullable=true)
    @Field
    @NumericField
    @FieldBridge(impl=BigDecimalNumericFieldBridge.class)
    public BigDecimal myValue;
    @Id
    @SequenceGenerator(name="SEQ_SPIDX_NUMBER", sequenceName="SEQ_SPIDX_NUMBER")
    @GeneratedValue(strategy=GenerationType.AUTO, generator="SEQ_SPIDX_NUMBER")
    @Column(name="SP_ID")
    private Long myId;
    @Column(name="HASH_IDENTITY", nullable=true)
    private Long myHashIdentity;

    public ResourceIndexedSearchParamNumber() {
    }

    public ResourceIndexedSearchParamNumber(String theParamName, BigDecimal theValue) {
        this.setParamName(theParamName);
        this.setValue(theValue);
    }

    @Override
    @PrePersist
    public void calculateHashes() {
        if (this.myHashIdentity == null) {
            String resourceType = this.getResourceType();
            String paramName = this.getParamName();
            this.setHashIdentity(ResourceIndexedSearchParamNumber.calculateHashIdentity(resourceType, paramName));
        }
    }

    @Override
    protected void clearHashes() {
        this.myHashIdentity = null;
    }

    @Override
    public boolean equals(Object theObj) {
        if (this == theObj) {
            return true;
        }
        if (theObj == null) {
            return false;
        }
        if (!(theObj instanceof ResourceIndexedSearchParamNumber)) {
            return false;
        }
        ResourceIndexedSearchParamNumber obj = (ResourceIndexedSearchParamNumber)theObj;
        EqualsBuilder b = new EqualsBuilder();
        b.append((Object)this.getParamName(), (Object)obj.getParamName());
        b.append((Object)this.getResource(), (Object)obj.getResource());
        b.append((Object)this.getValue(), (Object)obj.getValue());
        b.append(this.isMissing(), obj.isMissing());
        b.append((Object)this.getHashIdentity(), (Object)obj.getHashIdentity());
        return b.isEquals();
    }

    public Long getHashIdentity() {
        this.calculateHashes();
        return this.myHashIdentity;
    }

    public void setHashIdentity(Long theHashIdentity) {
        this.myHashIdentity = theHashIdentity;
    }

    @Override
    public Long getId() {
        return this.myId;
    }

    @Override
    public void setId(Long theId) {
        this.myId = theId;
    }

    public BigDecimal getValue() {
        return this.myValue;
    }

    public void setValue(BigDecimal theValue) {
        this.myValue = theValue;
    }

    @Override
    public int hashCode() {
        HashCodeBuilder b = new HashCodeBuilder();
        b.append((Object)this.getParamName());
        b.append((Object)this.getResource());
        b.append((Object)this.getValue());
        b.append(this.isMissing());
        return b.toHashCode();
    }

    @Override
    public IQueryParameterType toQueryParameterType() {
        return new NumberParam(this.myValue.toPlainString());
    }

    public String toString() {
        ToStringBuilder b = new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE);
        b.append("paramName", (Object)this.getParamName());
        b.append("resourceId", (Object)this.getResource().getId());
        b.append("value", (Object)this.getValue());
        return b.build();
    }

    @Override
    public boolean matches(IQueryParameterType theParam) {
        if (!(theParam instanceof NumberParam)) {
            return false;
        }
        NumberParam number = (NumberParam)theParam;
        return this.getValue().equals(number.getValue());
    }
}

