/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.model.entity;

import ca.uhn.fhir.jpa.model.entity.BaseResourceIndexedSearchParam;
import ca.uhn.fhir.jpa.model.util.BigDecimalNumericFieldBridge;
import ca.uhn.fhir.model.api.IQueryParameterType;
import ca.uhn.fhir.rest.param.QuantityParam;
import java.math.BigDecimal;
import javax.persistence.Column;
import javax.persistence.Embeddable;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.PrePersist;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.FieldBridge;
import org.hibernate.search.annotations.NumericField;

@Embeddable
@Entity
@Table(name="HFJ_SPIDX_QUANTITY", indexes={@Index(name="IDX_SP_QUANTITY_HASH", columnList="HASH_IDENTITY,SP_VALUE"), @Index(name="IDX_SP_QUANTITY_HASH_UN", columnList="HASH_IDENTITY_AND_UNITS,SP_VALUE"), @Index(name="IDX_SP_QUANTITY_HASH_SYSUN", columnList="HASH_IDENTITY_SYS_UNITS,SP_VALUE"), @Index(name="IDX_SP_QUANTITY_UPDATED", columnList="SP_UPDATED"), @Index(name="IDX_SP_QUANTITY_RESID", columnList="RES_ID")})
public class ResourceIndexedSearchParamQuantity
extends BaseResourceIndexedSearchParam {
    private static final int MAX_LENGTH = 200;
    private static final long serialVersionUID = 1L;
    @Column(name="SP_SYSTEM", nullable=true, length=200)
    @Field
    public String mySystem;
    @Column(name="SP_UNITS", nullable=true, length=200)
    @Field
    public String myUnits;
    @Column(name="SP_VALUE", nullable=true)
    @Field
    @NumericField
    @FieldBridge(impl=BigDecimalNumericFieldBridge.class)
    public BigDecimal myValue;
    @Id
    @SequenceGenerator(name="SEQ_SPIDX_QUANTITY", sequenceName="SEQ_SPIDX_QUANTITY")
    @GeneratedValue(strategy=GenerationType.AUTO, generator="SEQ_SPIDX_QUANTITY")
    @Column(name="SP_ID")
    private Long myId;
    @Column(name="HASH_IDENTITY_AND_UNITS", nullable=true)
    private Long myHashIdentityAndUnits;
    @Column(name="HASH_IDENTITY_SYS_UNITS", nullable=true)
    private Long myHashIdentitySystemAndUnits;
    @Column(name="HASH_IDENTITY", nullable=true)
    private Long myHashIdentity;

    public ResourceIndexedSearchParamQuantity() {
    }

    public ResourceIndexedSearchParamQuantity(String theParamName, BigDecimal theValue, String theSystem, String theUnits) {
        this();
        this.setParamName(theParamName);
        this.setSystem(theSystem);
        this.setValue(theValue);
        this.setUnits(theUnits);
    }

    @Override
    @PrePersist
    public void calculateHashes() {
        if (this.myHashIdentity == null) {
            String resourceType = this.getResourceType();
            String paramName = this.getParamName();
            String units = this.getUnits();
            String system = this.getSystem();
            this.setHashIdentity(ResourceIndexedSearchParamQuantity.calculateHashIdentity(resourceType, paramName));
            this.setHashIdentityAndUnits(ResourceIndexedSearchParamQuantity.calculateHashUnits(resourceType, paramName, units));
            this.setHashIdentitySystemAndUnits(ResourceIndexedSearchParamQuantity.calculateHashSystemAndUnits(resourceType, paramName, system, units));
        }
    }

    @Override
    protected void clearHashes() {
        this.myHashIdentity = null;
        this.myHashIdentityAndUnits = null;
    }

    @Override
    public boolean equals(Object theObj) {
        if (this == theObj) {
            return true;
        }
        if (theObj == null) {
            return false;
        }
        if (!(theObj instanceof ResourceIndexedSearchParamQuantity)) {
            return false;
        }
        ResourceIndexedSearchParamQuantity obj = (ResourceIndexedSearchParamQuantity)theObj;
        EqualsBuilder b = new EqualsBuilder();
        b.append((Object)this.getParamName(), (Object)obj.getParamName());
        b.append((Object)this.getResource(), (Object)obj.getResource());
        b.append((Object)this.getSystem(), (Object)obj.getSystem());
        b.append((Object)this.getUnits(), (Object)obj.getUnits());
        b.append((Object)this.getValue(), (Object)obj.getValue());
        b.append((Object)this.getHashIdentity(), (Object)obj.getHashIdentity());
        b.append((Object)this.getHashIdentitySystemAndUnits(), (Object)obj.getHashIdentitySystemAndUnits());
        b.append((Object)this.getHashIdentityAndUnits(), (Object)obj.getHashIdentityAndUnits());
        return b.isEquals();
    }

    public Long getHashIdentity() {
        this.calculateHashes();
        return this.myHashIdentity;
    }

    public void setHashIdentity(Long theHashIdentity) {
        this.myHashIdentity = theHashIdentity;
    }

    public Long getHashIdentityAndUnits() {
        this.calculateHashes();
        return this.myHashIdentityAndUnits;
    }

    public void setHashIdentityAndUnits(Long theHashIdentityAndUnits) {
        this.myHashIdentityAndUnits = theHashIdentityAndUnits;
    }

    private Long getHashIdentitySystemAndUnits() {
        this.calculateHashes();
        return this.myHashIdentitySystemAndUnits;
    }

    public void setHashIdentitySystemAndUnits(Long theHashIdentitySystemAndUnits) {
        this.myHashIdentitySystemAndUnits = theHashIdentitySystemAndUnits;
    }

    @Override
    public Long getId() {
        return this.myId;
    }

    @Override
    public void setId(Long theId) {
        this.myId = theId;
    }

    public String getSystem() {
        return this.mySystem;
    }

    public void setSystem(String theSystem) {
        this.clearHashes();
        this.mySystem = theSystem;
    }

    public String getUnits() {
        return this.myUnits;
    }

    public void setUnits(String theUnits) {
        this.clearHashes();
        this.myUnits = theUnits;
    }

    public BigDecimal getValue() {
        return this.myValue;
    }

    public void setValue(BigDecimal theValue) {
        this.clearHashes();
        this.myValue = theValue;
    }

    @Override
    public int hashCode() {
        this.calculateHashes();
        HashCodeBuilder b = new HashCodeBuilder();
        b.append((Object)this.getResourceType());
        b.append((Object)this.getParamName());
        b.append((Object)this.getSystem());
        b.append((Object)this.getUnits());
        b.append((Object)this.getValue());
        return b.toHashCode();
    }

    @Override
    public IQueryParameterType toQueryParameterType() {
        return new QuantityParam(null, this.getValue(), this.getSystem(), this.getUnits());
    }

    public String toString() {
        ToStringBuilder b = new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE);
        b.append("paramName", (Object)this.getParamName());
        b.append("resourceId", (Object)this.getResourcePid());
        b.append("system", (Object)this.getSystem());
        b.append("units", (Object)this.getUnits());
        b.append("value", (Object)this.getValue());
        b.append("missing", this.isMissing());
        b.append("hashIdentitySystemAndUnits", (Object)this.myHashIdentitySystemAndUnits);
        return b.build();
    }

    @Override
    public boolean matches(IQueryParameterType theParam) {
        if (!(theParam instanceof QuantityParam)) {
            return false;
        }
        QuantityParam quantity = (QuantityParam)theParam;
        boolean retval = false;
        if (quantity.getSystem() == null && quantity.getUnits() == null) {
            if (this.getValue().equals(quantity.getValue())) {
                retval = true;
            }
        } else if (quantity.getSystem() == null) {
            if (this.getUnits().equalsIgnoreCase(quantity.getUnits()) && this.getValue().equals(quantity.getValue())) {
                retval = true;
            }
        } else if (quantity.getUnits() == null) {
            if (this.getSystem().equalsIgnoreCase(quantity.getSystem()) && this.getValue().equals(quantity.getValue())) {
                retval = true;
            }
        } else if (this.getSystem().equalsIgnoreCase(quantity.getSystem()) && this.getUnits().equalsIgnoreCase(quantity.getUnits()) && this.getValue().equals(quantity.getValue())) {
            retval = true;
        }
        return retval;
    }

    public static long calculateHashSystemAndUnits(String theResourceType, String theParamName, String theSystem, String theUnits) {
        return ResourceIndexedSearchParamQuantity.hash(theResourceType, theParamName, theSystem, theUnits);
    }

    public static long calculateHashUnits(String theResourceType, String theParamName, String theUnits) {
        return ResourceIndexedSearchParamQuantity.hash(theResourceType, theParamName, theUnits);
    }
}

