/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.model.entity;

import ca.uhn.fhir.jpa.model.entity.BaseResourceIndexedSearchParam;
import ca.uhn.fhir.jpa.model.entity.ModelConfig;
import ca.uhn.fhir.jpa.model.entity.ResourceTable;
import ca.uhn.fhir.jpa.model.util.StringNormalizer;
import ca.uhn.fhir.model.api.IQueryParameterType;
import ca.uhn.fhir.rest.param.StringParam;
import javax.persistence.Column;
import javax.persistence.Embeddable;
import javax.persistence.Entity;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.PrePersist;
import javax.persistence.PreUpdate;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.hibernate.search.annotations.Analyze;
import org.hibernate.search.annotations.Analyzer;
import org.hibernate.search.annotations.ContainedIn;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.Fields;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.annotations.Store;

@Embeddable
@Entity
@Table(name="HFJ_SPIDX_STRING", indexes={@Index(name="IDX_SP_STRING_HASH_IDENT", columnList="HASH_IDENTITY"), @Index(name="IDX_SP_STRING_HASH_NRM", columnList="HASH_NORM_PREFIX,SP_VALUE_NORMALIZED"), @Index(name="IDX_SP_STRING_HASH_EXCT", columnList="HASH_EXACT"), @Index(name="IDX_SP_STRING_UPDATED", columnList="SP_UPDATED"), @Index(name="IDX_SP_STRING_RESID", columnList="RES_ID")})
@Indexed
public class ResourceIndexedSearchParamString
extends BaseResourceIndexedSearchParam {
    public static final int MAX_LENGTH = 200;
    public static final int HASH_PREFIX_LENGTH = 1;
    private static final long serialVersionUID = 1L;
    @Id
    @SequenceGenerator(name="SEQ_SPIDX_STRING", sequenceName="SEQ_SPIDX_STRING")
    @GeneratedValue(strategy=GenerationType.AUTO, generator="SEQ_SPIDX_STRING")
    @Column(name="SP_ID")
    private Long myId;
    @ManyToOne(optional=false)
    @JoinColumn(name="RES_ID", referencedColumnName="RES_ID", insertable=false, updatable=false, foreignKey=@ForeignKey(name="FK_SPIDXSTR_RESOURCE"))
    @ContainedIn
    private ResourceTable myResourceTable;
    @Column(name="SP_VALUE_EXACT", length=200, nullable=true)
    @Fields(value={@Field(name="myValueText", index=org.hibernate.search.annotations.Index.YES, store=Store.YES, analyze=Analyze.YES, analyzer=@Analyzer(definition="standardAnalyzer")), @Field(name="myValueTextEdgeNGram", index=org.hibernate.search.annotations.Index.YES, store=Store.NO, analyze=Analyze.YES, analyzer=@Analyzer(definition="autocompleteEdgeAnalyzer")), @Field(name="myValueTextNGram", index=org.hibernate.search.annotations.Index.YES, store=Store.NO, analyze=Analyze.YES, analyzer=@Analyzer(definition="autocompleteNGramAnalyzer")), @Field(name="myValueTextPhonetic", index=org.hibernate.search.annotations.Index.YES, store=Store.NO, analyze=Analyze.YES, analyzer=@Analyzer(definition="autocompletePhoneticAnalyzer"))})
    private String myValueExact;
    @Column(name="SP_VALUE_NORMALIZED", length=200, nullable=true)
    private String myValueNormalized;
    @Column(name="HASH_NORM_PREFIX", nullable=true)
    private Long myHashNormalizedPrefix;
    @Column(name="HASH_IDENTITY", nullable=true)
    private Long myHashIdentity;
    @Column(name="HASH_EXACT", nullable=true)
    private Long myHashExact;
    @Transient
    private transient ModelConfig myModelConfig;

    public ResourceIndexedSearchParamString() {
    }

    public ResourceIndexedSearchParamString(ModelConfig theModelConfig, String theName, String theValueNormalized, String theValueExact) {
        this.setModelConfig(theModelConfig);
        this.setParamName(theName);
        this.setValueNormalized(theValueNormalized);
        this.setValueExact(theValueExact);
    }

    public void setHashIdentity(Long theHashIdentity) {
        this.myHashIdentity = theHashIdentity;
    }

    @Override
    @PrePersist
    @PreUpdate
    public void calculateHashes() {
        if ((this.myHashIdentity == null || this.myHashNormalizedPrefix == null || this.myHashExact == null) && this.myModelConfig != null) {
            String resourceType = this.getResourceType();
            String paramName = this.getParamName();
            String valueNormalized = this.getValueNormalized();
            String valueExact = this.getValueExact();
            this.setHashNormalizedPrefix(ResourceIndexedSearchParamString.calculateHashNormalized(this.myModelConfig, resourceType, paramName, valueNormalized));
            this.setHashExact(ResourceIndexedSearchParamString.calculateHashExact(resourceType, paramName, valueExact));
            this.setHashIdentity(ResourceIndexedSearchParamString.calculateHashIdentity(resourceType, paramName));
        }
    }

    @Override
    protected void clearHashes() {
        this.myHashNormalizedPrefix = null;
        this.myHashExact = null;
    }

    @Override
    public boolean equals(Object theObj) {
        if (this == theObj) {
            return true;
        }
        if (theObj == null) {
            return false;
        }
        if (!(theObj instanceof ResourceIndexedSearchParamString)) {
            return false;
        }
        ResourceIndexedSearchParamString obj = (ResourceIndexedSearchParamString)theObj;
        EqualsBuilder b = new EqualsBuilder();
        b.append((Object)this.getParamName(), (Object)obj.getParamName());
        b.append((Object)this.getResource(), (Object)obj.getResource());
        b.append((Object)this.getValueExact(), (Object)obj.getValueExact());
        b.append((Object)this.getHashIdentity(), (Object)obj.getHashIdentity());
        b.append((Object)this.getHashExact(), (Object)obj.getHashExact());
        b.append((Object)this.getHashNormalizedPrefix(), (Object)obj.getHashNormalizedPrefix());
        return b.isEquals();
    }

    private Long getHashIdentity() {
        this.calculateHashes();
        return this.myHashIdentity;
    }

    public Long getHashExact() {
        this.calculateHashes();
        return this.myHashExact;
    }

    public void setHashExact(Long theHashExact) {
        this.myHashExact = theHashExact;
    }

    public Long getHashNormalizedPrefix() {
        this.calculateHashes();
        return this.myHashNormalizedPrefix;
    }

    public void setHashNormalizedPrefix(Long theHashNormalizedPrefix) {
        this.myHashNormalizedPrefix = theHashNormalizedPrefix;
    }

    @Override
    public Long getId() {
        return this.myId;
    }

    @Override
    public void setId(Long theId) {
        this.myId = theId;
    }

    public String getValueExact() {
        return this.myValueExact;
    }

    public void setValueExact(String theValueExact) {
        if (StringUtils.defaultString((String)theValueExact).length() > 200) {
            throw new IllegalArgumentException("Value is too long: " + theValueExact.length());
        }
        this.myValueExact = theValueExact;
    }

    public String getValueNormalized() {
        return this.myValueNormalized;
    }

    public void setValueNormalized(String theValueNormalized) {
        if (StringUtils.defaultString((String)theValueNormalized).length() > 200) {
            throw new IllegalArgumentException("Value is too long: " + theValueNormalized.length());
        }
        this.myValueNormalized = theValueNormalized;
    }

    @Override
    public int hashCode() {
        HashCodeBuilder b = new HashCodeBuilder();
        b.append((Object)this.getParamName());
        b.append((Object)this.getResource());
        b.append((Object)this.getValueExact());
        return b.toHashCode();
    }

    public BaseResourceIndexedSearchParam setModelConfig(ModelConfig theModelConfig) {
        this.myModelConfig = theModelConfig;
        return this;
    }

    @Override
    public IQueryParameterType toQueryParameterType() {
        return new StringParam(this.getValueExact());
    }

    public String toString() {
        ToStringBuilder b = new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE);
        b.append("paramName", (Object)this.getParamName());
        b.append("resourceId", (Object)this.getResourcePid());
        b.append("value", (Object)this.getValueNormalized());
        return b.build();
    }

    public static long calculateHashExact(String theResourceType, String theParamName, String theValueExact) {
        return ResourceIndexedSearchParamString.hash(theResourceType, theParamName, theValueExact);
    }

    public static long calculateHashNormalized(ModelConfig theModelConfig, String theResourceType, String theParamName, String theValueNormalized) {
        int hashPrefixLength = 1;
        if (theModelConfig.isAllowContainsSearches()) {
            hashPrefixLength = 0;
        }
        return ResourceIndexedSearchParamString.hash(theResourceType, theParamName, StringUtils.left((String)theValueNormalized, (int)hashPrefixLength));
    }

    @Override
    public boolean matches(IQueryParameterType theParam) {
        if (!(theParam instanceof StringParam)) {
            return false;
        }
        StringParam string = (StringParam)theParam;
        String normalizedString = StringNormalizer.normalizeString(string.getValue());
        return this.getValueNormalized().startsWith(normalizedString);
    }
}

