/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.model.entity;

import ca.uhn.fhir.jpa.model.entity.BaseResourceIndexedSearchParam;
import ca.uhn.fhir.model.api.IQueryParameterType;
import ca.uhn.fhir.rest.param.TokenParam;
import javax.persistence.Column;
import javax.persistence.Embeddable;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.PrePersist;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.hibernate.search.annotations.Field;

@Embeddable
@Entity
@Table(name="HFJ_SPIDX_TOKEN", indexes={@Index(name="IDX_SP_TOKEN_HASH", columnList="HASH_IDENTITY"), @Index(name="IDX_SP_TOKEN_HASH_S", columnList="HASH_SYS"), @Index(name="IDX_SP_TOKEN_HASH_SV", columnList="HASH_SYS_AND_VALUE"), @Index(name="IDX_SP_TOKEN_HASH_V", columnList="HASH_VALUE"), @Index(name="IDX_SP_TOKEN_UPDATED", columnList="SP_UPDATED"), @Index(name="IDX_SP_TOKEN_RESID", columnList="RES_ID")})
public class ResourceIndexedSearchParamToken
extends BaseResourceIndexedSearchParam {
    public static final int MAX_LENGTH = 200;
    private static final long serialVersionUID = 1L;
    @Field
    @Column(name="SP_SYSTEM", nullable=true, length=200)
    public String mySystem;
    @Field
    @Column(name="SP_VALUE", nullable=true, length=200)
    private String myValue;
    @Id
    @SequenceGenerator(name="SEQ_SPIDX_TOKEN", sequenceName="SEQ_SPIDX_TOKEN")
    @GeneratedValue(strategy=GenerationType.AUTO, generator="SEQ_SPIDX_TOKEN")
    @Column(name="SP_ID")
    private Long myId;
    @Column(name="HASH_IDENTITY", nullable=true)
    private Long myHashIdentity;
    @Column(name="HASH_SYS", nullable=true)
    private Long myHashSystem;
    @Column(name="HASH_SYS_AND_VALUE", nullable=true)
    private Long myHashSystemAndValue;
    @Column(name="HASH_VALUE", nullable=true)
    private Long myHashValue;

    public ResourceIndexedSearchParamToken() {
    }

    public ResourceIndexedSearchParamToken(String theName, String theSystem, String theValue) {
        this.setParamName(theName);
        this.setSystem(theSystem);
        this.setValue(theValue);
    }

    @Override
    @PrePersist
    public void calculateHashes() {
        if (this.myHashSystem == null) {
            String resourceType = this.getResourceType();
            String paramName = this.getParamName();
            String system = this.getSystem();
            String value = this.getValue();
            this.setHashIdentity(ResourceIndexedSearchParamToken.calculateHashIdentity(resourceType, paramName));
            this.setHashSystem(ResourceIndexedSearchParamToken.calculateHashSystem(resourceType, paramName, system));
            this.setHashSystemAndValue(ResourceIndexedSearchParamToken.calculateHashSystemAndValue(resourceType, paramName, system, value));
            this.setHashValue(ResourceIndexedSearchParamToken.calculateHashValue(resourceType, paramName, value));
        }
    }

    @Override
    protected void clearHashes() {
        this.myHashSystem = null;
        this.myHashSystemAndValue = null;
        this.myHashValue = null;
    }

    @Override
    public boolean equals(Object theObj) {
        if (this == theObj) {
            return true;
        }
        if (theObj == null) {
            return false;
        }
        if (!(theObj instanceof ResourceIndexedSearchParamToken)) {
            return false;
        }
        ResourceIndexedSearchParamToken obj = (ResourceIndexedSearchParamToken)theObj;
        EqualsBuilder b = new EqualsBuilder();
        b.append((Object)this.getParamName(), (Object)obj.getParamName());
        b.append((Object)this.getResource(), (Object)obj.getResource());
        b.append((Object)this.getSystem(), (Object)obj.getSystem());
        b.append((Object)this.getValue(), (Object)obj.getValue());
        b.append((Object)this.getHashIdentity(), (Object)obj.getHashIdentity());
        b.append((Object)this.getHashSystem(), (Object)obj.getHashSystem());
        b.append((Object)this.getHashSystemAndValue(), (Object)obj.getHashSystemAndValue());
        b.append((Object)this.getHashValue(), (Object)obj.getHashValue());
        return b.isEquals();
    }

    Long getHashSystem() {
        this.calculateHashes();
        return this.myHashSystem;
    }

    private void setHashSystem(Long theHashSystem) {
        this.myHashSystem = theHashSystem;
    }

    private Long getHashIdentity() {
        this.calculateHashes();
        return this.myHashIdentity;
    }

    private void setHashIdentity(Long theHashIdentity) {
        this.myHashIdentity = theHashIdentity;
    }

    Long getHashSystemAndValue() {
        this.calculateHashes();
        return this.myHashSystemAndValue;
    }

    private void setHashSystemAndValue(Long theHashSystemAndValue) {
        this.calculateHashes();
        this.myHashSystemAndValue = theHashSystemAndValue;
    }

    Long getHashValue() {
        this.calculateHashes();
        return this.myHashValue;
    }

    private void setHashValue(Long theHashValue) {
        this.myHashValue = theHashValue;
    }

    @Override
    public Long getId() {
        return this.myId;
    }

    @Override
    public void setId(Long theId) {
        this.myId = theId;
    }

    public String getSystem() {
        return this.mySystem;
    }

    public void setSystem(String theSystem) {
        this.clearHashes();
        this.mySystem = (String)StringUtils.defaultIfBlank((CharSequence)theSystem, null);
    }

    public String getValue() {
        return this.myValue;
    }

    public void setValue(String theValue) {
        this.clearHashes();
        this.myValue = (String)StringUtils.defaultIfBlank((CharSequence)theValue, null);
    }

    @Override
    public int hashCode() {
        this.calculateHashes();
        HashCodeBuilder b = new HashCodeBuilder();
        b.append((Object)this.getParamName());
        b.append((Object)this.getResource());
        b.append((Object)this.getSystem());
        b.append((Object)this.getValue());
        return b.toHashCode();
    }

    @Override
    public IQueryParameterType toQueryParameterType() {
        return new TokenParam(this.getSystem(), this.getValue());
    }

    public String toString() {
        ToStringBuilder b = new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE);
        b.append("paramName", (Object)this.getParamName());
        b.append("resourceId", (Object)this.getResourcePid());
        b.append("system", (Object)this.getSystem());
        b.append("value", (Object)this.getValue());
        return b.build();
    }

    @Override
    public boolean matches(IQueryParameterType theParam) {
        if (!(theParam instanceof TokenParam)) {
            return false;
        }
        TokenParam token = (TokenParam)theParam;
        boolean retval = false;
        if (token.getSystem() == null || token.getSystem().isEmpty()) {
            if (this.getValue().equalsIgnoreCase(token.getValue())) {
                retval = true;
            }
        } else if (token.getValue() == null || token.getValue().isEmpty()) {
            if (token.getSystem().equalsIgnoreCase(this.getSystem())) {
                retval = true;
            }
        } else if (token.getSystem().equalsIgnoreCase(this.getSystem()) && this.getValue().equalsIgnoreCase(token.getValue())) {
            retval = true;
        }
        return retval;
    }

    public static long calculateHashSystem(String theResourceType, String theParamName, String theSystem) {
        return ResourceIndexedSearchParamToken.hash(theResourceType, theParamName, StringUtils.trim((String)theSystem));
    }

    public static long calculateHashSystemAndValue(String theResourceType, String theParamName, String theSystem, String theValue) {
        return ResourceIndexedSearchParamToken.hash(theResourceType, theParamName, StringUtils.defaultString((String)StringUtils.trim((String)theSystem)), StringUtils.trim((String)theValue));
    }

    public static long calculateHashValue(String theResourceType, String theParamName, String theValue) {
        return ResourceIndexedSearchParamToken.hash(theResourceType, theParamName, StringUtils.trim((String)theValue));
    }
}

