/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.model.entity;

import ca.uhn.fhir.jpa.model.entity.BaseResourceIndex;
import ca.uhn.fhir.jpa.model.entity.ResourceTable;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.hibernate.search.annotations.Field;
import org.hl7.fhir.instance.model.api.IIdType;

@Entity
@Table(name="HFJ_RES_LINK", indexes={@Index(name="IDX_RL_TPATHRES", columnList="SRC_PATH,TARGET_RESOURCE_ID"), @Index(name="IDX_RL_SRC", columnList="SRC_RESOURCE_ID"), @Index(name="IDX_RL_DEST", columnList="TARGET_RESOURCE_ID")})
public class ResourceLink
extends BaseResourceIndex {
    public static final int SRC_PATH_LENGTH = 200;
    private static final long serialVersionUID = 1L;
    @SequenceGenerator(name="SEQ_RESLINK_ID", sequenceName="SEQ_RESLINK_ID")
    @GeneratedValue(strategy=GenerationType.AUTO, generator="SEQ_RESLINK_ID")
    @Id
    @Column(name="PID")
    private Long myId;
    @Column(name="SRC_PATH", length=200, nullable=false)
    private String mySourcePath;
    @ManyToOne(optional=false, fetch=FetchType.LAZY)
    @JoinColumn(name="SRC_RESOURCE_ID", referencedColumnName="RES_ID", nullable=false, foreignKey=@ForeignKey(name="FK_RESLINK_SOURCE"))
    private ResourceTable mySourceResource;
    @Column(name="SRC_RESOURCE_ID", insertable=false, updatable=false, nullable=false)
    private Long mySourceResourcePid;
    @Column(name="SOURCE_RESOURCE_TYPE", nullable=false, length=30)
    @Field
    private String mySourceResourceType;
    @ManyToOne(optional=true, fetch=FetchType.LAZY)
    @JoinColumn(name="TARGET_RESOURCE_ID", referencedColumnName="RES_ID", nullable=true, foreignKey=@ForeignKey(name="FK_RESLINK_TARGET"))
    private ResourceTable myTargetResource;
    @Column(name="TARGET_RESOURCE_ID", insertable=false, updatable=false, nullable=true)
    @Field
    private Long myTargetResourcePid;
    @Column(name="TARGET_RESOURCE_TYPE", nullable=false, length=30)
    @Field
    private String myTargetResourceType;
    @Column(name="TARGET_RESOURCE_URL", length=200, nullable=true)
    @Field
    private String myTargetResourceUrl;
    @Field
    @Column(name="SP_UPDATED", nullable=true)
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date myUpdated;

    public ResourceLink() {
    }

    public ResourceLink(String theSourcePath, ResourceTable theSourceResource, IIdType theTargetResourceUrl, Date theUpdated) {
        this.setSourcePath(theSourcePath);
        this.setSourceResource(theSourceResource);
        this.setTargetResourceUrl(theTargetResourceUrl);
        this.setUpdated(theUpdated);
    }

    public ResourceLink(String theSourcePath, ResourceTable theSourceResource, ResourceTable theTargetResource, Date theUpdated) {
        this.setSourcePath(theSourcePath);
        this.setSourceResource(theSourceResource);
        this.setTargetResource(theTargetResource);
        this.setUpdated(theUpdated);
    }

    @Override
    public boolean equals(Object theObj) {
        if (this == theObj) {
            return true;
        }
        if (theObj == null) {
            return false;
        }
        if (!(theObj instanceof ResourceLink)) {
            return false;
        }
        ResourceLink obj = (ResourceLink)theObj;
        EqualsBuilder b = new EqualsBuilder();
        b.append((Object)this.mySourcePath, (Object)obj.mySourcePath);
        b.append((Object)this.mySourceResource, (Object)obj.mySourceResource);
        b.append((Object)this.myTargetResourcePid, (Object)obj.myTargetResourcePid);
        b.append((Object)this.myTargetResourceUrl, (Object)obj.myTargetResourceUrl);
        return b.isEquals();
    }

    public String getSourcePath() {
        return this.mySourcePath;
    }

    public void setSourcePath(String theSourcePath) {
        this.mySourcePath = theSourcePath;
    }

    public ResourceTable getSourceResource() {
        return this.mySourceResource;
    }

    public void setSourceResource(ResourceTable theSourceResource) {
        this.mySourceResource = theSourceResource;
        this.mySourceResourcePid = theSourceResource.getId();
        this.mySourceResourceType = theSourceResource.getResourceType();
    }

    public Long getSourceResourcePid() {
        return this.mySourceResourcePid;
    }

    public ResourceTable getTargetResource() {
        return this.myTargetResource;
    }

    public void setTargetResource(ResourceTable theTargetResource) {
        Validate.notNull((Object)theTargetResource);
        this.myTargetResource = theTargetResource;
        this.myTargetResourcePid = theTargetResource.getId();
        this.myTargetResourceType = theTargetResource.getResourceType();
    }

    public Long getTargetResourcePid() {
        return this.myTargetResourcePid;
    }

    public String getTargetResourceUrl() {
        return this.myTargetResourceUrl;
    }

    public void setTargetResourceUrl(IIdType theTargetResourceUrl) {
        Validate.isTrue((boolean)theTargetResourceUrl.hasBaseUrl());
        Validate.isTrue((boolean)theTargetResourceUrl.hasResourceType());
        if (theTargetResourceUrl.hasIdPart()) {
            // empty if block
        }
        this.myTargetResourceType = theTargetResourceUrl.getResourceType();
        this.myTargetResourceUrl = theTargetResourceUrl.getValue();
    }

    public Date getUpdated() {
        return this.myUpdated;
    }

    public void setUpdated(Date theUpdated) {
        this.myUpdated = theUpdated;
    }

    @Override
    public Long getId() {
        return this.myId;
    }

    @Override
    public void setId(Long theId) {
        this.myId = theId;
    }

    @Override
    public void calculateHashes() {
    }

    @Override
    public int hashCode() {
        HashCodeBuilder b = new HashCodeBuilder();
        b.append((Object)this.mySourcePath);
        b.append((Object)this.mySourceResource);
        b.append((Object)this.myTargetResourcePid);
        b.append((Object)this.myTargetResourceUrl);
        return b.toHashCode();
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("ResourceLink[");
        b.append("path=").append(this.mySourcePath);
        b.append(", src=").append(this.mySourceResourcePid);
        b.append(", target=").append(this.myTargetResourcePid);
        b.append(", targetUrl=").append(this.myTargetResourceUrl);
        b.append("]");
        return b.toString();
    }
}

