/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.model.entity;

import ca.uhn.fhir.jpa.model.entity.BaseTag;
import ca.uhn.fhir.jpa.model.entity.ResourceTable;
import ca.uhn.fhir.jpa.model.entity.TagDefinition;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.UniqueConstraint;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

@Entity
@Table(name="HFJ_RES_TAG", uniqueConstraints={@UniqueConstraint(name="IDX_RESTAG_TAGID", columnNames={"RES_ID", "TAG_ID"})})
public class ResourceTag
extends BaseTag {
    private static final long serialVersionUID = 1L;
    @SequenceGenerator(name="SEQ_RESTAG_ID", sequenceName="SEQ_RESTAG_ID")
    @GeneratedValue(strategy=GenerationType.AUTO, generator="SEQ_RESTAG_ID")
    @Id
    @Column(name="PID")
    private Long myId;
    @ManyToOne(cascade={})
    @JoinColumn(name="RES_ID", referencedColumnName="RES_ID", foreignKey=@ForeignKey(name="FK_RESTAG_RESOURCE"))
    private ResourceTable myResource;
    @Column(name="RES_TYPE", length=30, nullable=false)
    private String myResourceType;
    @Column(name="RES_ID", insertable=false, updatable=false)
    private Long myResourceId;

    public Long getResourceId() {
        return this.myResourceId;
    }

    public void setResourceId(Long theResourceId) {
        this.myResourceId = theResourceId;
    }

    public ResourceTag() {
    }

    public ResourceTag(ResourceTable theResourceTable, TagDefinition theTag) {
        this.setTag(theTag);
        this.setResource(theResourceTable);
        this.setResourceId(theResourceTable.getId());
        this.setResourceType(theResourceTable.getResourceType());
    }

    public ResourceTable getResource() {
        return this.myResource;
    }

    public String getResourceType() {
        return this.myResourceType;
    }

    public void setResource(ResourceTable theResource) {
        this.myResource = theResource;
    }

    public void setResourceType(String theResourceType) {
        this.myResourceType = theResourceType;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResourceTag)) {
            return false;
        }
        ResourceTag other = (ResourceTag)obj;
        EqualsBuilder b = new EqualsBuilder();
        b.append((Object)this.getResourceId(), (Object)other.getResourceId());
        b.append((Object)this.getTag(), (Object)other.getTag());
        return b.isEquals();
    }

    public int hashCode() {
        HashCodeBuilder b = new HashCodeBuilder();
        b.append((Object)this.getResourceId());
        b.append((Object)this.getTag());
        return b.toHashCode();
    }

    public String toString() {
        ToStringBuilder b = new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE);
        b.append("resId", (Object)this.getResourceId());
        b.append("tag", (Object)this.getTag().getId());
        return b.build();
    }
}

