/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.model.entity;

import ca.uhn.fhir.jpa.model.entity.ResourceHistoryTag;
import ca.uhn.fhir.jpa.model.entity.ResourceTag;
import ca.uhn.fhir.jpa.model.entity.TagTypeEnum;
import ca.uhn.fhir.model.api.Tag;
import java.io.Serializable;
import java.util.Collection;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.persistence.UniqueConstraint;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

@Entity
@Table(name="HFJ_TAG_DEF", uniqueConstraints={@UniqueConstraint(name="IDX_TAGDEF_TYPESYSCODE", columnNames={"TAG_TYPE", "TAG_SYSTEM", "TAG_CODE"})})
public class TagDefinition
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Column(name="TAG_CODE", length=200)
    private String myCode;
    @Column(name="TAG_DISPLAY", length=200)
    private String myDisplay;
    @Id
    @GeneratedValue(strategy=GenerationType.AUTO, generator="SEQ_TAGDEF_ID")
    @SequenceGenerator(name="SEQ_TAGDEF_ID", sequenceName="SEQ_TAGDEF_ID")
    @Column(name="TAG_ID")
    private Long myId;
    @OneToMany(cascade={}, fetch=FetchType.LAZY, mappedBy="myTag")
    private Collection<ResourceTag> myResources;
    @OneToMany(cascade={}, fetch=FetchType.LAZY, mappedBy="myTag")
    private Collection<ResourceHistoryTag> myResourceVersions;
    @Column(name="TAG_SYSTEM", length=200)
    private String mySystem;
    @Column(name="TAG_TYPE", nullable=false)
    @Enumerated(value=EnumType.ORDINAL)
    private TagTypeEnum myTagType;
    @Transient
    private transient Integer myHashCode;

    public TagDefinition() {
    }

    public TagDefinition(TagTypeEnum theTagType, String theSystem, String theCode, String theDisplay) {
        this.setTagType(theTagType);
        this.setCode(theCode);
        this.setSystem(theSystem);
        this.setDisplay(theDisplay);
    }

    public String getCode() {
        return this.myCode;
    }

    public String getDisplay() {
        return this.myDisplay;
    }

    public Long getId() {
        return this.myId;
    }

    public String getSystem() {
        return this.mySystem;
    }

    public TagTypeEnum getTagType() {
        return this.myTagType;
    }

    public void setCode(String theCode) {
        this.myCode = theCode;
        this.myHashCode = null;
    }

    public void setDisplay(String theDisplay) {
        this.myDisplay = theDisplay;
    }

    public void setSystem(String theSystem) {
        this.mySystem = theSystem;
        this.myHashCode = null;
    }

    public void setTagType(TagTypeEnum theTagType) {
        this.myTagType = theTagType;
        this.myHashCode = null;
    }

    public Tag toTag() {
        return new Tag(this.getSystem(), this.getCode(), this.getDisplay());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TagDefinition)) {
            return false;
        }
        TagDefinition other = (TagDefinition)obj;
        EqualsBuilder b = new EqualsBuilder();
        if (this.myId != null && other.myId != null) {
            b.append((Object)this.myId, (Object)other.myId);
        } else {
            b.append((Object)this.myTagType, (Object)other.myTagType);
            b.append((Object)this.mySystem, (Object)other.mySystem);
            b.append((Object)this.myCode, (Object)other.myCode);
        }
        return b.isEquals();
    }

    public int hashCode() {
        if (this.myHashCode == null) {
            HashCodeBuilder b = new HashCodeBuilder();
            b.append((Object)this.myTagType);
            b.append((Object)this.mySystem);
            b.append((Object)this.myCode);
            this.myHashCode = b.toHashCode();
        }
        return this.myHashCode;
    }

    public String toString() {
        ToStringBuilder retVal = new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE);
        retVal.append("id", (Object)this.myId);
        retVal.append("system", (Object)this.mySystem);
        retVal.append("code", (Object)this.myCode);
        retVal.append("display", (Object)this.myDisplay);
        return retVal.build();
    }
}

