/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.model.interceptor.executor;

import ca.uhn.fhir.jpa.model.interceptor.api.Hook;
import ca.uhn.fhir.jpa.model.interceptor.api.HookParams;
import ca.uhn.fhir.jpa.model.interceptor.api.IAnonymousLambdaHook;
import ca.uhn.fhir.jpa.model.interceptor.api.IInterceptorBroadcaster;
import ca.uhn.fhir.jpa.model.interceptor.api.IInterceptorRegistry;
import ca.uhn.fhir.jpa.model.interceptor.api.Pointcut;
import ca.uhn.fhir.rest.server.exceptions.InternalErrorException;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.apache.commons.collections4.ListUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

@Component
public class InterceptorService
implements IInterceptorRegistry,
IInterceptorBroadcaster {
    private static final Logger ourLog = LoggerFactory.getLogger(InterceptorService.class);
    private final List<Object> myInterceptors = new ArrayList<Object>();
    private final ListMultimap<Pointcut, BaseInvoker> myInvokers = ArrayListMultimap.create();
    private final ListMultimap<Pointcut, BaseInvoker> myAnonymousInvokers = ArrayListMultimap.create();
    private final Object myRegistryMutex = new Object();

    @VisibleForTesting
    List<Object> getGlobalInterceptorsForUnitTest() {
        return this.myInterceptors;
    }

    @Override
    @VisibleForTesting
    public void registerAnonymousHookForUnitTest(Pointcut thePointcut, IAnonymousLambdaHook theHook) {
        this.registerAnonymousHookForUnitTest(thePointcut, 0, theHook);
    }

    @Override
    public void registerAnonymousHookForUnitTest(Pointcut thePointcut, int theOrder, IAnonymousLambdaHook theHook) {
        Validate.notNull((Object)((Object)thePointcut));
        Validate.notNull((Object)theHook);
        this.myAnonymousInvokers.put((Object)thePointcut, (Object)new AnonymousLambdaInvoker(theHook, theOrder));
    }

    @Override
    @VisibleForTesting
    public void clearAnonymousHookForUnitTest() {
        this.myAnonymousInvokers.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean registerInterceptor(Object theInterceptor) {
        Object object = this.myRegistryMutex;
        synchronized (object) {
            if (this.isInterceptorAlreadyRegistered(theInterceptor)) {
                return false;
            }
            Class<?> interceptorClass = theInterceptor.getClass();
            int typeOrder = this.determineOrder(interceptorClass);
            if (!this.scanInterceptorForHookMethodsAndAddThem(theInterceptor, typeOrder)) {
                return false;
            }
            this.myInterceptors.add(theInterceptor);
            this.sortByOrderAnnotation(this.myInterceptors);
            for (Pointcut nextPointcut : this.myInvokers.keys()) {
                List nextInvokerList = this.myInvokers.get((Object)nextPointcut);
                nextInvokerList.sort(Comparator.naturalOrder());
            }
            return true;
        }
    }

    private boolean scanInterceptorForHookMethodsAndAddThem(Object theInterceptor, int theTypeOrder) {
        boolean retVal = false;
        for (Method nextMethod : theInterceptor.getClass().getDeclaredMethods()) {
            Hook hook = (Hook)AnnotationUtils.findAnnotation((Method)nextMethod, Hook.class);
            if (hook == null) continue;
            int methodOrder = theTypeOrder;
            Order methodOrderAnnotation = (Order)AnnotationUtils.findAnnotation((Method)nextMethod, Order.class);
            if (methodOrderAnnotation != null) {
                methodOrder = methodOrderAnnotation.value();
            }
            HookInvoker invoker = new HookInvoker(hook, theInterceptor, nextMethod, methodOrder);
            for (Pointcut nextPointcut : hook.value()) {
                this.myInvokers.put((Object)nextPointcut, (Object)invoker);
            }
            retVal = true;
        }
        return retVal;
    }

    private int determineOrder(Class<?> theInterceptorClass) {
        int typeOrder = 0;
        Order typeOrderAnnotation = (Order)AnnotationUtils.findAnnotation(theInterceptorClass, Order.class);
        if (typeOrderAnnotation != null) {
            typeOrder = typeOrderAnnotation.value();
        }
        return typeOrder;
    }

    private boolean isInterceptorAlreadyRegistered(Object theInterceptor) {
        for (Object next : this.myInterceptors) {
            if (next != theInterceptor) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregisterInterceptor(Object theInterceptor) {
        Object object = this.myRegistryMutex;
        synchronized (object) {
            this.myInterceptors.removeIf(t -> t == theInterceptor);
            this.myInvokers.entries().removeIf(t -> ((BaseInvoker)t.getValue()).getInterceptor() == theInterceptor);
        }
    }

    @Override
    public boolean registerGlobalInterceptor(Object theInterceptor) {
        return this.registerInterceptor(theInterceptor);
    }

    @Override
    public void unregisterGlobalInterceptor(Object theInterceptor) {
        this.unregisterInterceptor(theInterceptor);
    }

    private void sortByOrderAnnotation(List<Object> theObjects) {
        IdentityHashMap<Object, Integer> interceptorToOrder = new IdentityHashMap<Object, Integer>();
        for (Object next : theObjects) {
            Order orderAnnotation = next.getClass().getAnnotation(Order.class);
            int order = orderAnnotation != null ? orderAnnotation.value() : 0;
            interceptorToOrder.put(next, order);
        }
        theObjects.sort((a, b) -> {
            Integer orderA = (Integer)interceptorToOrder.get(a);
            Integer orderB = (Integer)interceptorToOrder.get(b);
            return orderA - orderB;
        });
    }

    @Override
    public boolean callHooks(Pointcut thePointcut, Object ... theParams) {
        return this.callHooks(thePointcut, new HookParams(theParams));
    }

    @Override
    public boolean callHooks(Pointcut thePointcut, HookParams theParams) {
        assert (this.haveAppropriateParams(thePointcut, theParams));
        List<BaseInvoker> invokers = this.getInvokersForPointcut(thePointcut);
        for (BaseInvoker nextInvoker : invokers) {
            boolean shouldContinue = nextInvoker.invoke(theParams);
            if (shouldContinue) continue;
            return false;
        }
        return true;
    }

    @VisibleForTesting
    List<Object> getInterceptorsWithInvokersForPointcut(Pointcut thePointcut) {
        return this.getInvokersForPointcut(thePointcut).stream().map(BaseInvoker::getInterceptor).collect(Collectors.toList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<BaseInvoker> getInvokersForPointcut(Pointcut thePointcut) {
        boolean haveAnonymousInvokers;
        List invokers;
        Object object = this.myRegistryMutex;
        synchronized (object) {
            List globalInvokers = this.myInvokers.get((Object)thePointcut);
            List anonymousInvokers = this.myAnonymousInvokers.get((Object)thePointcut);
            invokers = ListUtils.union((List)anonymousInvokers, (List)globalInvokers);
            haveAnonymousInvokers = !anonymousInvokers.isEmpty();
        }
        if (haveAnonymousInvokers) {
            invokers.sort(Comparator.naturalOrder());
        }
        return invokers;
    }

    boolean haveAppropriateParams(Pointcut thePointcut, HookParams theParams) {
        Validate.isTrue((theParams.getParamsForType().values().size() == thePointcut.getParameterTypes().size() ? 1 : 0) != 0, (String)"Wrong number of params for pointcut %s - Wanted %s but found %s", (Object[])new Object[]{thePointcut.name(), InterceptorService.toErrorString(thePointcut.getParameterTypes()), theParams.getParamsForType().values().stream().map(t -> t.getClass().getSimpleName()).sorted().collect(Collectors.toList())});
        ArrayList<String> wantedTypes = new ArrayList<String>(thePointcut.getParameterTypes());
        ListMultimap<Class<?>, Object> givenTypes = theParams.getParamsForType();
        for (Class nextTypeClass : givenTypes.keySet()) {
            String nextTypeName = nextTypeClass.getName();
            for (Object nextParamValue : givenTypes.get((Object)nextTypeClass)) {
                Validate.isTrue((boolean)nextTypeClass.isAssignableFrom(nextParamValue.getClass()), (String)"Invalid params for pointcut %s - %s is not of type %s", (Object[])new Object[]{thePointcut.name(), nextParamValue.getClass(), nextTypeClass});
                Validate.isTrue((boolean)wantedTypes.remove(nextTypeName), (String)"Invalid params for pointcut %s - Wanted %s but missing %s", (Object[])new Object[]{thePointcut.name(), InterceptorService.toErrorString(thePointcut.getParameterTypes()), nextTypeName});
            }
        }
        return true;
    }

    private static String toErrorString(List<String> theParameterTypes) {
        return theParameterTypes.stream().sorted().collect(Collectors.joining(","));
    }

    private class HookInvoker
    extends BaseInvoker {
        private final boolean myReturnsBoolean;
        private final Method myMethod;
        private final Class<?>[] myParameterTypes;
        private final int[] myParameterIndexes;

        private HookInvoker(@Nonnull Hook theHook, @Nonnull Object theInterceptor, Method theHookMethod, int theOrder) {
            super(theInterceptor, theOrder);
            this.myParameterTypes = theHookMethod.getParameterTypes();
            this.myMethod = theHookMethod;
            Class<?> returnType = theHookMethod.getReturnType();
            if (returnType.equals(Boolean.TYPE)) {
                this.myReturnsBoolean = true;
            } else {
                Validate.isTrue((boolean)Void.TYPE.equals(returnType), (String)"Method does not return boolean or void: %s", (Object[])new Object[]{theHookMethod});
                this.myReturnsBoolean = false;
            }
            this.myParameterIndexes = new int[this.myParameterTypes.length];
            HashMap<Class, AtomicInteger> typeToCount = new HashMap<Class, AtomicInteger>();
            for (int i = 0; i < this.myParameterTypes.length; ++i) {
                AtomicInteger counter = typeToCount.computeIfAbsent(this.myParameterTypes[i], t -> new AtomicInteger(0));
                this.myParameterIndexes[i] = counter.getAndIncrement();
            }
        }

        @Override
        boolean invoke(HookParams theParams) {
            Object[] args = new Object[this.myParameterTypes.length];
            for (int i = 0; i < this.myParameterTypes.length; ++i) {
                Class<?> nextParamType = this.myParameterTypes[i];
                int nextParamIndex = this.myParameterIndexes[i];
                Object nextParamValue = theParams.get(nextParamType, nextParamIndex);
                args[i] = nextParamValue;
            }
            try {
                Object returnValue = this.myMethod.invoke(this.getInterceptor(), args);
                if (this.myReturnsBoolean) {
                    return (Boolean)returnValue;
                }
                return true;
            }
            catch (InvocationTargetException e) {
                Throwable targetException = e.getTargetException();
                if (targetException instanceof RuntimeException) {
                    throw (RuntimeException)targetException;
                }
                throw new InternalErrorException(targetException);
            }
            catch (Exception e) {
                throw new InternalErrorException((Throwable)e);
            }
        }
    }

    private class AnonymousLambdaInvoker
    extends BaseInvoker {
        private final IAnonymousLambdaHook myHook;

        public AnonymousLambdaInvoker(IAnonymousLambdaHook theHook, int theOrder) {
            super(theHook, theOrder);
            this.myHook = theHook;
        }

        @Override
        boolean invoke(HookParams theParams) {
            this.myHook.invoke(theParams);
            return true;
        }
    }

    private abstract class BaseInvoker
    implements Comparable<BaseInvoker> {
        private final int myOrder;
        private final Object myInterceptor;

        BaseInvoker(Object theInterceptor, int theOrder) {
            this.myInterceptor = theInterceptor;
            this.myOrder = theOrder;
        }

        public Object getInterceptor() {
            return this.myInterceptor;
        }

        abstract boolean invoke(HookParams var1);

        @Override
        public int compareTo(BaseInvoker o) {
            return this.myOrder - o.myOrder;
        }
    }
}

