/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.model.util;

import java.math.BigDecimal;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexableField;
import org.hibernate.search.bridge.LuceneOptions;
import org.hibernate.search.bridge.TwoWayFieldBridge;

public class BigDecimalNumericFieldBridge
implements TwoWayFieldBridge {
    public void set(String name, Object value, Document document, LuceneOptions luceneOptions) {
        if (value == null) {
            if (luceneOptions.indexNullAs() != null) {
                luceneOptions.addFieldToDocument(name, luceneOptions.indexNullAs(), document);
            }
        } else {
            BigDecimal bdValue = (BigDecimal)value;
            this.applyToLuceneOptions(luceneOptions, name, bdValue.doubleValue(), document);
        }
    }

    public final String objectToString(Object object) {
        return object == null ? null : object.toString();
    }

    public Object get(String name, Document document) {
        IndexableField field = document.getField(name);
        if (field != null) {
            Double doubleVal = (Double)field.numericValue();
            return new BigDecimal(doubleVal);
        }
        return null;
    }

    protected void applyToLuceneOptions(LuceneOptions luceneOptions, String name, Number value, Document document) {
        luceneOptions.addNumericFieldToDocument(name, (Object)value, document);
    }
}

