/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.model.entity;

import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.jpa.model.cross.IBasePersistedResource;
import ca.uhn.fhir.jpa.model.entity.BasePartitionable;
import ca.uhn.fhir.jpa.model.entity.BaseTag;
import ca.uhn.fhir.jpa.model.entity.ForcedId;
import ca.uhn.fhir.jpa.model.entity.IBaseResourceEntity;
import ca.uhn.fhir.jpa.model.entity.TagDefinition;
import ca.uhn.fhir.model.primitive.InstantDt;
import java.util.Collection;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.MappedSuperclass;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.annotations.OptimisticLock;

@MappedSuperclass
public abstract class BaseHasResource
extends BasePartitionable
implements IBaseResourceEntity,
IBasePersistedResource {
    @Column(name="RES_DELETED_AT", nullable=true)
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date myDeleted;
    @Column(name="RES_VERSION", nullable=true, length=7)
    @Enumerated(value=EnumType.STRING)
    @OptimisticLock(excluded=true)
    private FhirVersionEnum myFhirVersion;
    @Column(name="HAS_TAGS", nullable=false)
    @OptimisticLock(excluded=true)
    private boolean myHasTags;
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="RES_PUBLISHED", nullable=false)
    @OptimisticLock(excluded=true)
    private Date myPublished;
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="RES_UPDATED", nullable=false)
    @OptimisticLock(excluded=true)
    private Date myUpdated;
    @Transient
    private transient String myTransientForcedId;

    public String getTransientForcedId() {
        return this.myTransientForcedId;
    }

    public void setTransientForcedId(String theTransientForcedId) {
        assert (!StringUtils.defaultString((String)theTransientForcedId).contains("/")) : "Forced ID should not include type: " + theTransientForcedId;
        this.myTransientForcedId = theTransientForcedId;
    }

    public abstract BaseTag addTag(TagDefinition var1);

    @Override
    public Date getDeleted() {
        return BaseHasResource.cloneDate(this.myDeleted);
    }

    @Override
    public FhirVersionEnum getFhirVersion() {
        return this.myFhirVersion;
    }

    public void setFhirVersion(FhirVersionEnum theFhirVersion) {
        this.myFhirVersion = theFhirVersion;
    }

    public abstract ForcedId getForcedId();

    public abstract void setForcedId(ForcedId var1);

    @Override
    public abstract Long getId();

    @Override
    public boolean isDeleted() {
        return this.myDeleted != null;
    }

    public void setDeleted(Date theDate) {
        this.myDeleted = theDate;
    }

    @Override
    public InstantDt getPublished() {
        if (this.myPublished != null) {
            return new InstantDt(BaseHasResource.cloneDate(this.myPublished));
        }
        return null;
    }

    public void setPublished(Date thePublished) {
        this.myPublished = thePublished;
    }

    public void setPublished(InstantDt thePublished) {
        this.myPublished = (Date)thePublished.getValue();
    }

    @Override
    public abstract Long getResourceId();

    @Override
    public abstract String getResourceType();

    public abstract Collection<? extends BaseTag> getTags();

    @Override
    public InstantDt getUpdated() {
        return new InstantDt(BaseHasResource.cloneDate(this.myUpdated));
    }

    public void setUpdated(Date theUpdated) {
        this.myUpdated = theUpdated;
    }

    public void setUpdated(InstantDt theUpdated) {
        this.myUpdated = (Date)theUpdated.getValue();
    }

    @Override
    public Date getUpdatedDate() {
        return BaseHasResource.cloneDate(this.myUpdated);
    }

    @Override
    public abstract long getVersion();

    @Override
    public boolean isHasTags() {
        return this.myHasTags;
    }

    public void setHasTags(boolean theHasTags) {
        this.myHasTags = theHasTags;
    }

    static Date cloneDate(Date theDate) {
        Date retVal = theDate;
        if (retVal != null) {
            retVal = new Date(retVal.getTime());
        }
        return retVal;
    }
}

