/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.model.entity;

import ca.uhn.fhir.interceptor.model.RequestPartitionId;
import ca.uhn.fhir.jpa.model.config.PartitionSettings;
import ca.uhn.fhir.jpa.model.entity.BaseResourceIndex;
import ca.uhn.fhir.jpa.model.entity.ModelConfig;
import ca.uhn.fhir.jpa.model.entity.ResourceTable;
import ca.uhn.fhir.model.api.IQueryParameterType;
import ca.uhn.fhir.util.UrlUtil;
import com.google.common.base.Charsets;
import com.google.common.hash.HashCode;
import com.google.common.hash.HashFunction;
import com.google.common.hash.Hasher;
import com.google.common.hash.Hashing;
import java.util.Date;
import javax.annotation.Nullable;
import javax.persistence.Column;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.MappedSuperclass;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import org.hibernate.search.annotations.ContainedIn;
import org.hibernate.search.annotations.Field;

@MappedSuperclass
public abstract class BaseResourceIndexedSearchParam
extends BaseResourceIndex {
    static final int MAX_SP_NAME = 100;
    private static final HashFunction HASH_FUNCTION = Hashing.murmur3_128((int)0);
    private static final byte[] DELIMITER_BYTES = "|".getBytes(Charsets.UTF_8);
    private static final long serialVersionUID = 1L;
    @Field
    @Column(name="SP_MISSING", nullable=false)
    private boolean myMissing = false;
    @Field
    @Column(name="SP_NAME", length=100, nullable=false)
    private String myParamName;
    @ManyToOne(optional=false, fetch=FetchType.LAZY, cascade={})
    @JoinColumn(name="RES_ID", referencedColumnName="RES_ID", nullable=false)
    @ContainedIn
    private ResourceTable myResource;
    @Column(name="RES_ID", insertable=false, updatable=false, nullable=false)
    private Long myResourcePid;
    @Field
    @Column(name="RES_TYPE", updatable=false, nullable=false, length=100)
    private String myResourceType;
    @Field
    @Column(name="SP_UPDATED", nullable=true)
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date myUpdated;
    @Transient
    private transient PartitionSettings myPartitionSettings;
    @Transient
    private transient ModelConfig myModelConfig;

    @Override
    public abstract Long getId();

    public String getParamName() {
        return this.myParamName;
    }

    public void setParamName(String theName) {
        this.myParamName = theName;
    }

    public ResourceTable getResource() {
        return this.myResource;
    }

    public BaseResourceIndexedSearchParam setResource(ResourceTable theResource) {
        this.myResource = theResource;
        this.myResourceType = theResource.getResourceType();
        return this;
    }

    @Override
    public <T extends BaseResourceIndex> void copyMutableValuesFrom(T theSource) {
        BaseResourceIndexedSearchParam source = (BaseResourceIndexedSearchParam)theSource;
        this.myMissing = source.myMissing;
        this.myParamName = source.myParamName;
        this.myUpdated = source.myUpdated;
        this.myModelConfig = source.myModelConfig;
        this.myPartitionSettings = source.myPartitionSettings;
        this.setPartitionId(source.getPartitionId());
    }

    public Long getResourcePid() {
        return this.myResourcePid;
    }

    public String getResourceType() {
        return this.myResourceType;
    }

    public void setResourceType(String theResourceType) {
        this.myResourceType = theResourceType;
    }

    public Date getUpdated() {
        return this.myUpdated;
    }

    public void setUpdated(Date theUpdated) {
        this.myUpdated = theUpdated;
    }

    public boolean isMissing() {
        return this.myMissing;
    }

    public BaseResourceIndexedSearchParam setMissing(boolean theMissing) {
        this.myMissing = theMissing;
        return this;
    }

    public abstract IQueryParameterType toQueryParameterType();

    @Override
    public void setPartitionId(@Nullable RequestPartitionId theRequestPartitionId) {
        super.setPartitionId(theRequestPartitionId);
    }

    public boolean matches(IQueryParameterType theParam, boolean theUseOrdinalDatesForDayComparison) {
        throw new UnsupportedOperationException("No parameter matcher for " + theParam);
    }

    public PartitionSettings getPartitionSettings() {
        return this.myPartitionSettings;
    }

    public BaseResourceIndexedSearchParam setPartitionSettings(PartitionSettings thePartitionSettings) {
        this.myPartitionSettings = thePartitionSettings;
        return this;
    }

    public BaseResourceIndexedSearchParam setModelConfig(ModelConfig theModelConfig) {
        this.myModelConfig = theModelConfig;
        return this;
    }

    public ModelConfig getModelConfig() {
        return this.myModelConfig;
    }

    public static long calculateHashIdentity(PartitionSettings thePartitionSettings, RequestPartitionId theRequestPartitionId, String theResourceType, String theParamName) {
        return BaseResourceIndexedSearchParam.hash(thePartitionSettings, theRequestPartitionId, theResourceType, theParamName);
    }

    static long hash(PartitionSettings thePartitionSettings, RequestPartitionId theRequestPartitionId, String ... theValues) {
        Hasher hasher = HASH_FUNCTION.newHasher();
        if (thePartitionSettings.isPartitioningEnabled() && thePartitionSettings.isIncludePartitionInSearchHashes() && theRequestPartitionId != null && theRequestPartitionId.getPartitionId() != null) {
            hasher.putInt(theRequestPartitionId.getPartitionId().intValue());
        }
        for (String next : theValues) {
            if (next == null) {
                hasher.putByte((byte)0);
            } else {
                next = UrlUtil.escapeUrlParam((String)next);
                byte[] bytes = next.getBytes(Charsets.UTF_8);
                hasher.putBytes(bytes);
            }
            hasher.putBytes(DELIMITER_BYTES);
        }
        HashCode hashCode = hasher.hash();
        return hashCode.asLong();
    }
}

