/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.model.entity;

import ca.uhn.fhir.jpa.model.entity.BasePartitionable;
import ca.uhn.fhir.jpa.model.entity.ResourceTable;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.OneToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.UniqueConstraint;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.hibernate.annotations.ColumnDefault;

@Entity
@Table(name="HFJ_FORCED_ID", uniqueConstraints={@UniqueConstraint(name="IDX_FORCEDID_RESID", columnNames={"RESOURCE_PID"}), @UniqueConstraint(name="IDX_FORCEDID_TYPE_FID", columnNames={"RESOURCE_TYPE", "FORCED_ID"})}, indexes={})
public class ForcedId
extends BasePartitionable {
    public static final int MAX_FORCED_ID_LENGTH = 100;
    public static final String IDX_FORCEDID_TYPE_FID = "IDX_FORCEDID_TYPE_FID";
    public static final String HFJ_FORCED_ID = "HFJ_FORCED_ID";
    @Column(name="FORCED_ID", nullable=false, length=100, updatable=false)
    private String myForcedId;
    @SequenceGenerator(name="SEQ_FORCEDID_ID", sequenceName="SEQ_FORCEDID_ID")
    @GeneratedValue(strategy=GenerationType.AUTO, generator="SEQ_FORCEDID_ID")
    @Id
    @Column(name="PID")
    private Long myId;
    @JoinColumn(name="RESOURCE_PID", nullable=false, updatable=false, foreignKey=@ForeignKey(name="FK_FORCEDID_RESOURCE"))
    @OneToOne(fetch=FetchType.LAZY)
    private ResourceTable myResource;
    @Column(name="RESOURCE_PID", nullable=false, updatable=false, insertable=false)
    private Long myResourcePid;
    @ColumnDefault(value="''")
    @Column(name="RESOURCE_TYPE", nullable=true, length=100, updatable=true)
    private String myResourceType;

    public String getForcedId() {
        return this.myForcedId;
    }

    public void setForcedId(String theForcedId) {
        this.myForcedId = theForcedId;
    }

    public void setResource(ResourceTable theResource) {
        this.myResource = theResource;
    }

    public String getResourceType() {
        return this.myResourceType;
    }

    public void setResourceType(String theResourceType) {
        this.myResourceType = theResourceType;
    }

    public Long getId() {
        return this.myId;
    }

    public Long getResourceId() {
        return this.myResourcePid;
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append("pid", (Object)this.myId).append("resourceType", (Object)this.myResourceType).append("forcedId", (Object)this.myForcedId).append("resourcePid", (Object)this.myResourcePid).toString();
    }
}

