/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.model.entity;

import ca.uhn.fhir.jpa.model.entity.NpmPackageVersionEntity;
import java.util.Date;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.UniqueConstraint;
import javax.persistence.Version;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;

@Entity
@Table(name="NPM_PACKAGE", uniqueConstraints={@UniqueConstraint(name="IDX_PACK_ID", columnNames={"PACKAGE_ID"})})
public class NpmPackageEntity {
    protected static final int PACKAGE_ID_LENGTH = 200;
    @SequenceGenerator(name="SEQ_NPM_PACK", sequenceName="SEQ_NPM_PACK")
    @GeneratedValue(strategy=GenerationType.AUTO, generator="SEQ_NPM_PACK")
    @Id
    @Column(name="PID")
    private Long myId;
    @Column(name="PACKAGE_ID", length=200, nullable=false)
    private String myPackageId;
    @Column(name="CUR_VERSION_ID", length=200, nullable=true)
    private String myCurrentVersionId;
    @Temporal(value=TemporalType.TIMESTAMP)
    @Version
    @Column(name="UPDATED_TIME", nullable=false)
    private Date myVersion;
    @Column(name="PACKAGE_DESC", length=200, nullable=true)
    private String myDescription;
    @OneToMany(mappedBy="myPackage")
    private List<NpmPackageVersionEntity> myVersions;

    public String getDescription() {
        return this.myDescription;
    }

    public void setDescription(String theDescription) {
        this.myDescription = theDescription;
    }

    public String getPackageId() {
        return this.myPackageId;
    }

    public void setPackageId(String thePackageId) {
        this.myPackageId = thePackageId;
    }

    public boolean equals(Object theO) {
        if (this == theO) {
            return true;
        }
        if (theO == null || this.getClass() != theO.getClass()) {
            return false;
        }
        NpmPackageEntity that = (NpmPackageEntity)theO;
        return new EqualsBuilder().append((Object)this.myPackageId, (Object)that.myPackageId).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 37).append((Object)this.myPackageId).toHashCode();
    }

    public String getCurrentVersionId() {
        return this.myCurrentVersionId;
    }

    public void setCurrentVersionId(String theCurrentVersionId) {
        this.myCurrentVersionId = theCurrentVersionId;
    }
}

