/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.model.entity;

import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.jpa.model.entity.NpmPackageVersionEntity;
import ca.uhn.fhir.jpa.model.entity.ResourceTable;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Version;

@Entity
@Table(name="NPM_PACKAGE_VER_RES", uniqueConstraints={}, indexes={@Index(name="IDX_PACKVERRES_URL", columnList="CANONICAL_URL")})
public class NpmPackageVersionResourceEntity {
    @Id
    @SequenceGenerator(name="SEQ_NPM_PACKVERRES", sequenceName="SEQ_NPM_PACKVERRES")
    @GeneratedValue(strategy=GenerationType.AUTO, generator="SEQ_NPM_PACKVERRES")
    @Column(name="PID")
    private Long myId;
    @ManyToOne
    @JoinColumn(name="PACKVER_PID", referencedColumnName="PID", foreignKey=@ForeignKey(name="FK_NPM_PACKVERRES_PACKVER"), nullable=false)
    private NpmPackageVersionEntity myPackageVersion;
    @OneToOne
    @JoinColumn(name="BINARY_RES_ID", referencedColumnName="RES_ID", nullable=false, foreignKey=@ForeignKey(name="FK_NPM_PKVR_RESID"))
    private ResourceTable myResourceBinary;
    @Column(name="FILE_DIR", length=200)
    private String myDirectory;
    @Column(name="FILE_NAME", length=200)
    private String myFilename;
    @Column(name="RES_TYPE", length=40, nullable=false)
    private String myResourceType;
    @Column(name="CANONICAL_URL", length=200)
    private String myCanonicalUrl;
    @Column(name="CANONICAL_VERSION", length=200)
    private String myCanonicalVersion;
    @Enumerated(value=EnumType.STRING)
    @Column(name="FHIR_VERSION", length=10, nullable=false)
    private FhirVersionEnum myFhirVersion;
    @Column(name="FHIR_VERSION_ID", length=10, nullable=false)
    private String myFhirVersionId;
    @Column(name="RES_SIZE_BYTES", nullable=false)
    private long myResSizeBytes;
    @Temporal(value=TemporalType.TIMESTAMP)
    @Version
    @Column(name="UPDATED_TIME", nullable=false)
    private Date myVersion;

    public long getResSizeBytes() {
        return this.myResSizeBytes;
    }

    public void setResSizeBytes(long theResSizeBytes) {
        this.myResSizeBytes = theResSizeBytes;
    }

    public String getCanonicalVersion() {
        return this.myCanonicalVersion;
    }

    public void setCanonicalVersion(String theCanonicalVersion) {
        this.myCanonicalVersion = theCanonicalVersion;
    }

    public ResourceTable getResourceBinary() {
        return this.myResourceBinary;
    }

    public void setResourceBinary(ResourceTable theResourceBinary) {
        this.myResourceBinary = theResourceBinary;
    }

    public String getFhirVersionId() {
        return this.myFhirVersionId;
    }

    public void setFhirVersionId(String theFhirVersionId) {
        this.myFhirVersionId = theFhirVersionId;
    }

    public FhirVersionEnum getFhirVersion() {
        return this.myFhirVersion;
    }

    public void setFhirVersion(FhirVersionEnum theFhirVersion) {
        this.myFhirVersion = theFhirVersion;
    }

    public void setPackageVersion(NpmPackageVersionEntity thePackageVersion) {
        this.myPackageVersion = thePackageVersion;
    }

    public String getDirectory() {
        return this.myDirectory;
    }

    public void setDirectory(String theDirectory) {
        this.myDirectory = theDirectory;
    }

    public String getFilename() {
        return this.myFilename;
    }

    public void setFilename(String theFilename) {
        this.myFilename = theFilename;
    }

    public String getResourceType() {
        return this.myResourceType;
    }

    public void setResourceType(String theResourceType) {
        this.myResourceType = theResourceType;
    }

    public String getCanonicalUrl() {
        return this.myCanonicalUrl;
    }

    public void setCanonicalUrl(String theCanonicalUrl) {
        this.myCanonicalUrl = theCanonicalUrl;
    }
}

