/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.model.entity;

import ca.uhn.fhir.jpa.model.entity.BaseHasResource;
import ca.uhn.fhir.jpa.model.entity.ForcedId;
import ca.uhn.fhir.jpa.model.entity.ResourceEncodingEnum;
import ca.uhn.fhir.jpa.model.entity.ResourceHistoryProvenanceEntity;
import ca.uhn.fhir.jpa.model.entity.ResourceHistoryTag;
import ca.uhn.fhir.jpa.model.entity.ResourceTable;
import ca.uhn.fhir.jpa.model.entity.ResourceTag;
import ca.uhn.fhir.jpa.model.entity.TagDefinition;
import ca.uhn.fhir.model.primitive.IdDt;
import ca.uhn.fhir.rest.api.server.storage.ResourcePersistentId;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.JoinColumn;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.UniqueConstraint;
import org.hibernate.annotations.OptimisticLock;

@Entity
@Table(name="HFJ_RES_VER", uniqueConstraints={@UniqueConstraint(name="IDX_RESVER_ID_VER", columnNames={"RES_ID", "RES_VER"})}, indexes={@Index(name="IDX_RESVER_TYPE_DATE", columnList="RES_TYPE,RES_UPDATED"), @Index(name="IDX_RESVER_ID_DATE", columnList="RES_ID,RES_UPDATED"), @Index(name="IDX_RESVER_DATE", columnList="RES_UPDATED")})
public class ResourceHistoryTable
extends BaseHasResource
implements Serializable {
    public static final String IDX_RESVER_ID_VER = "IDX_RESVER_ID_VER";
    public static final int ENCODING_COL_LENGTH = 5;
    public static final String HFJ_RES_VER = "HFJ_RES_VER";
    private static final long serialVersionUID = 1L;
    @Id
    @SequenceGenerator(name="SEQ_RESOURCE_HISTORY_ID", sequenceName="SEQ_RESOURCE_HISTORY_ID")
    @GeneratedValue(strategy=GenerationType.AUTO, generator="SEQ_RESOURCE_HISTORY_ID")
    @Column(name="PID")
    private Long myId;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="RES_ID", nullable=false, updatable=false, foreignKey=@ForeignKey(name="FK_RESOURCE_HISTORY_RESOURCE"))
    private ResourceTable myResourceTable;
    @Column(name="RES_ID", nullable=false, updatable=false, insertable=false)
    private Long myResourceId;
    @Column(name="RES_TYPE", length=40, nullable=false)
    private String myResourceType;
    @Column(name="RES_VER", nullable=false)
    private Long myResourceVersion;
    @OneToMany(mappedBy="myResourceHistory", cascade={CascadeType.ALL}, fetch=FetchType.LAZY, orphanRemoval=true)
    private Collection<ResourceHistoryTag> myTags;
    @Column(name="RES_TEXT", length=0x7FFFFFFE, nullable=true)
    @Lob
    @OptimisticLock(excluded=true)
    private byte[] myResource;
    @Column(name="RES_ENCODING", nullable=false, length=5)
    @Enumerated(value=EnumType.STRING)
    @OptimisticLock(excluded=true)
    private ResourceEncodingEnum myEncoding;
    @OneToOne(mappedBy="myResourceHistoryTable", cascade={CascadeType.REMOVE})
    private ResourceHistoryProvenanceEntity myProvenance;

    public ResourceHistoryProvenanceEntity getProvenance() {
        return this.myProvenance;
    }

    public void addTag(ResourceTag theTag) {
        ResourceHistoryTag tag = new ResourceHistoryTag(this, theTag.getTag(), this.getPartitionId());
        tag.setResourceType(theTag.getResourceType());
        this.getTags().add(tag);
    }

    @Override
    public ResourceHistoryTag addTag(TagDefinition theTag) {
        for (ResourceHistoryTag next : this.getTags()) {
            if (!next.getTag().equals(theTag)) continue;
            return next;
        }
        ResourceHistoryTag historyTag = new ResourceHistoryTag(this, theTag, this.getPartitionId());
        this.getTags().add(historyTag);
        return historyTag;
    }

    public ResourceEncodingEnum getEncoding() {
        return this.myEncoding;
    }

    public void setEncoding(ResourceEncodingEnum theEncoding) {
        this.myEncoding = theEncoding;
    }

    @Override
    public Long getId() {
        return this.myId;
    }

    public byte[] getResource() {
        return this.myResource;
    }

    public void setResource(byte[] theResource) {
        this.myResource = theResource;
    }

    @Override
    public Long getResourceId() {
        return this.myResourceId;
    }

    public void setResourceId(Long theResourceId) {
        this.myResourceId = theResourceId;
    }

    @Override
    public String getResourceType() {
        return this.myResourceType;
    }

    public void setResourceType(String theResourceType) {
        this.myResourceType = theResourceType;
    }

    public Collection<ResourceHistoryTag> getTags() {
        if (this.myTags == null) {
            this.myTags = new ArrayList<ResourceHistoryTag>();
        }
        return this.myTags;
    }

    @Override
    public long getVersion() {
        return this.myResourceVersion;
    }

    public void setVersion(long theVersion) {
        this.myResourceVersion = theVersion;
    }

    @Override
    public ResourcePersistentId getPersistentId() {
        return new ResourcePersistentId((Object)this.myResourceId);
    }

    public ResourceTable getResourceTable() {
        return this.myResourceTable;
    }

    public void setResourceTable(ResourceTable theResourceTable) {
        this.myResourceTable = theResourceTable;
    }

    @Override
    public IdDt getIdDt() {
        String resourceIdPart;
        if (this.getTransientForcedId() != null) {
            resourceIdPart = this.getTransientForcedId();
        } else if (this.getResourceTable().getForcedId() == null) {
            Long id = this.getResourceId();
            resourceIdPart = id.toString();
        } else {
            resourceIdPart = this.getResourceTable().getForcedId().getForcedId();
        }
        return new IdDt(this.getResourceType() + '/' + resourceIdPart + '/' + "_history" + '/' + this.getVersion());
    }

    @Override
    public ForcedId getForcedId() {
        return this.getResourceTable().getForcedId();
    }

    @Override
    public void setForcedId(ForcedId theForcedId) {
        this.getResourceTable().setForcedId(theForcedId);
    }
}

