/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.model.entity;

import ca.uhn.fhir.interceptor.model.RequestPartitionId;
import ca.uhn.fhir.jpa.model.entity.BaseTag;
import ca.uhn.fhir.jpa.model.entity.ResourceHistoryTable;
import ca.uhn.fhir.jpa.model.entity.TagDefinition;
import java.io.Serializable;
import javax.persistence.Column;
import javax.persistence.Embeddable;
import javax.persistence.Entity;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.UniqueConstraint;

@Embeddable
@Entity
@Table(name="HFJ_HISTORY_TAG", uniqueConstraints={@UniqueConstraint(name="IDX_RESHISTTAG_TAGID", columnNames={"RES_VER_PID", "TAG_ID"})})
public class ResourceHistoryTag
extends BaseTag
implements Serializable {
    private static final long serialVersionUID = 1L;
    @SequenceGenerator(name="SEQ_HISTORYTAG_ID", sequenceName="SEQ_HISTORYTAG_ID")
    @GeneratedValue(strategy=GenerationType.AUTO, generator="SEQ_HISTORYTAG_ID")
    @Id
    @Column(name="PID")
    private Long myId;
    @ManyToOne
    @JoinColumn(name="RES_VER_PID", referencedColumnName="PID", nullable=false, foreignKey=@ForeignKey(name="FK_HISTORYTAG_HISTORY"))
    private ResourceHistoryTable myResourceHistory;
    @Column(name="RES_VER_PID", insertable=false, updatable=false, nullable=false)
    private Long myResourceHistoryPid;
    @Column(name="RES_TYPE", length=40, nullable=false)
    private String myResourceType;
    @Column(name="RES_ID", nullable=false)
    private Long myResourceId;

    public String getResourceType() {
        return this.myResourceType;
    }

    public void setResourceType(String theResourceType) {
        this.myResourceType = theResourceType;
    }

    public Long getResourceId() {
        return this.myResourceId;
    }

    public void setResourceId(Long theResourceId) {
        this.myResourceId = theResourceId;
    }

    public ResourceHistoryTag() {
    }

    public ResourceHistoryTag(ResourceHistoryTable theResourceHistoryTable, TagDefinition theTag, RequestPartitionId theRequestPartitionId) {
        this.setTag(theTag);
        this.setResource(theResourceHistoryTable);
        this.setResourceId(theResourceHistoryTable.getResourceId());
        this.setResourceType(theResourceHistoryTable.getResourceType());
        this.setPartitionId(theRequestPartitionId);
    }

    public ResourceHistoryTable getResourceHistory() {
        return this.myResourceHistory;
    }

    public void setResource(ResourceHistoryTable theResourceHistory) {
        this.myResourceHistory = theResourceHistory;
    }

    public Long getId() {
        return this.myId;
    }
}

