/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.model.entity;

import ca.uhn.fhir.jpa.model.entity.BasePartitionable;
import ca.uhn.fhir.jpa.model.entity.ResourceTable;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.builder.CompareToBuilder;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

@Entity
@Table(name="HFJ_IDX_CMP_STRING_UNIQ", indexes={@Index(name="IDX_IDXCMPSTRUNIQ_STRING", columnList="IDX_STRING", unique=true), @Index(name="IDX_IDXCMPSTRUNIQ_RESOURCE", columnList="RES_ID", unique=false)})
public class ResourceIndexedCompositeStringUnique
extends BasePartitionable
implements Comparable<ResourceIndexedCompositeStringUnique> {
    public static final int MAX_STRING_LENGTH = 200;
    public static final String IDX_IDXCMPSTRUNIQ_STRING = "IDX_IDXCMPSTRUNIQ_STRING";
    public static final String IDX_IDXCMPSTRUNIQ_RESOURCE = "IDX_IDXCMPSTRUNIQ_RESOURCE";
    @SequenceGenerator(name="SEQ_IDXCMPSTRUNIQ_ID", sequenceName="SEQ_IDXCMPSTRUNIQ_ID")
    @GeneratedValue(strategy=GenerationType.AUTO, generator="SEQ_IDXCMPSTRUNIQ_ID")
    @Id
    @Column(name="PID")
    private Long myId;
    @ManyToOne
    @JoinColumn(name="RES_ID", referencedColumnName="RES_ID", foreignKey=@ForeignKey(name="FK_IDXCMPSTRUNIQ_RES_ID"))
    private ResourceTable myResource;
    @Column(name="RES_ID", insertable=false, updatable=false)
    private Long myResourceId;
    @Column(name="IDX_STRING", nullable=false, length=200)
    private String myIndexString;
    @Column(name="PARTITION_ID", insertable=false, updatable=false, nullable=true)
    private Integer myPartitionIdValue;

    public ResourceIndexedCompositeStringUnique() {
    }

    public ResourceIndexedCompositeStringUnique(ResourceTable theResource, String theIndexString) {
        this.setResource(theResource);
        this.setIndexString(theIndexString);
        this.setPartitionId(theResource.getPartitionId());
    }

    @Override
    public int compareTo(ResourceIndexedCompositeStringUnique theO) {
        CompareToBuilder b = new CompareToBuilder();
        b.append((Object)this.myIndexString, (Object)theO.getIndexString());
        return b.toComparison();
    }

    public boolean equals(Object theO) {
        if (this == theO) {
            return true;
        }
        if (!(theO instanceof ResourceIndexedCompositeStringUnique)) {
            return false;
        }
        ResourceIndexedCompositeStringUnique that = (ResourceIndexedCompositeStringUnique)theO;
        return new EqualsBuilder().append((Object)this.myIndexString, (Object)that.myIndexString).isEquals();
    }

    public String getIndexString() {
        return this.myIndexString;
    }

    public void setIndexString(String theIndexString) {
        this.myIndexString = theIndexString;
    }

    public ResourceTable getResource() {
        return this.myResource;
    }

    public void setResource(ResourceTable theResource) {
        Validate.notNull((Object)theResource);
        this.myResource = theResource;
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 37).append((Object)this.myIndexString).toHashCode();
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append("id", (Object)this.myId).append("resourceId", (Object)this.myResourceId).append("indexString", (Object)this.myIndexString).append("partition", (Object)this.getPartitionId()).toString();
    }
}

