/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.model.entity;

import ca.uhn.fhir.interceptor.model.RequestPartitionId;
import ca.uhn.fhir.jpa.model.config.PartitionSettings;
import ca.uhn.fhir.jpa.model.entity.BaseResourceIndex;
import ca.uhn.fhir.jpa.model.entity.BaseResourceIndexedSearchParam;
import ca.uhn.fhir.model.api.IQueryParameterType;
import ca.uhn.fhir.rest.param.TokenParam;
import javax.persistence.Column;
import javax.persistence.Embeddable;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.hibernate.search.annotations.Field;

@Embeddable
@Entity
@Table(name="HFJ_SPIDX_TOKEN", indexes={@Index(name="IDX_SP_TOKEN_HASH", columnList="HASH_IDENTITY"), @Index(name="IDX_SP_TOKEN_HASH_S", columnList="HASH_SYS"), @Index(name="IDX_SP_TOKEN_HASH_SV", columnList="HASH_SYS_AND_VALUE"), @Index(name="IDX_SP_TOKEN_HASH_V", columnList="HASH_VALUE"), @Index(name="IDX_SP_TOKEN_UPDATED", columnList="SP_UPDATED"), @Index(name="IDX_SP_TOKEN_RESID", columnList="RES_ID")})
public class ResourceIndexedSearchParamToken
extends BaseResourceIndexedSearchParam {
    public static final int MAX_LENGTH = 200;
    private static final long serialVersionUID = 1L;
    @Field
    @Column(name="SP_SYSTEM", nullable=true, length=200)
    public String mySystem;
    @Field
    @Column(name="SP_VALUE", nullable=true, length=200)
    private String myValue;
    @Id
    @SequenceGenerator(name="SEQ_SPIDX_TOKEN", sequenceName="SEQ_SPIDX_TOKEN")
    @GeneratedValue(strategy=GenerationType.AUTO, generator="SEQ_SPIDX_TOKEN")
    @Column(name="SP_ID")
    private Long myId;
    @Column(name="HASH_IDENTITY", nullable=true)
    private Long myHashIdentity;
    @Column(name="HASH_SYS", nullable=true)
    private Long myHashSystem;
    @Column(name="HASH_SYS_AND_VALUE", nullable=true)
    private Long myHashSystemAndValue;
    @Column(name="HASH_VALUE", nullable=true)
    private Long myHashValue;

    public ResourceIndexedSearchParamToken() {
    }

    public ResourceIndexedSearchParamToken(PartitionSettings thePartitionSettings, String theResourceType, String theParamName, String theSystem, String theValue) {
        this.setPartitionSettings(thePartitionSettings);
        this.setResourceType(theResourceType);
        this.setParamName(theParamName);
        this.setSystem(theSystem);
        this.setValue(theValue);
        this.calculateHashes();
    }

    @Override
    public <T extends BaseResourceIndex> void copyMutableValuesFrom(T theSource) {
        super.copyMutableValuesFrom(theSource);
        ResourceIndexedSearchParamToken source = (ResourceIndexedSearchParamToken)theSource;
        this.mySystem = source.mySystem;
        this.myValue = source.myValue;
        this.myHashSystem = source.myHashSystem;
        this.myHashSystemAndValue = source.getHashSystemAndValue();
        this.myHashValue = source.myHashValue;
        this.myHashIdentity = source.myHashIdentity;
    }

    @Override
    public void calculateHashes() {
        String resourceType = this.getResourceType();
        String paramName = this.getParamName();
        String system = this.getSystem();
        String value = this.getValue();
        this.setHashIdentity(ResourceIndexedSearchParamToken.calculateHashIdentity(this.getPartitionSettings(), this.getPartitionId(), resourceType, paramName));
        this.setHashSystem(ResourceIndexedSearchParamToken.calculateHashSystem(this.getPartitionSettings(), this.getPartitionId(), resourceType, paramName, system));
        this.setHashSystemAndValue(ResourceIndexedSearchParamToken.calculateHashSystemAndValue(this.getPartitionSettings(), this.getPartitionId(), resourceType, paramName, system, value));
        this.setHashValue(ResourceIndexedSearchParamToken.calculateHashValue(this.getPartitionSettings(), this.getPartitionId(), resourceType, paramName, value));
    }

    @Override
    public boolean equals(Object theObj) {
        if (this == theObj) {
            return true;
        }
        if (theObj == null) {
            return false;
        }
        if (!(theObj instanceof ResourceIndexedSearchParamToken)) {
            return false;
        }
        ResourceIndexedSearchParamToken obj = (ResourceIndexedSearchParamToken)theObj;
        EqualsBuilder b = new EqualsBuilder();
        b.append((Object)this.getHashSystem(), (Object)obj.getHashSystem());
        b.append((Object)this.getHashValue(), (Object)obj.getHashValue());
        b.append((Object)this.getHashSystemAndValue(), (Object)obj.getHashSystemAndValue());
        return b.isEquals();
    }

    Long getHashSystem() {
        return this.myHashSystem;
    }

    private void setHashSystem(Long theHashSystem) {
        this.myHashSystem = theHashSystem;
    }

    private void setHashIdentity(Long theHashIdentity) {
        this.myHashIdentity = theHashIdentity;
    }

    Long getHashSystemAndValue() {
        return this.myHashSystemAndValue;
    }

    private void setHashSystemAndValue(Long theHashSystemAndValue) {
        this.myHashSystemAndValue = theHashSystemAndValue;
    }

    Long getHashValue() {
        return this.myHashValue;
    }

    private void setHashValue(Long theHashValue) {
        this.myHashValue = theHashValue;
    }

    @Override
    public Long getId() {
        return this.myId;
    }

    @Override
    public void setId(Long theId) {
        this.myId = theId;
    }

    public String getSystem() {
        return this.mySystem;
    }

    public void setSystem(String theSystem) {
        this.mySystem = (String)StringUtils.defaultIfBlank((CharSequence)theSystem, null);
    }

    public String getValue() {
        return this.myValue;
    }

    public ResourceIndexedSearchParamToken setValue(String theValue) {
        this.myValue = (String)StringUtils.defaultIfBlank((CharSequence)theValue, null);
        return this;
    }

    @Override
    public int hashCode() {
        HashCodeBuilder b = new HashCodeBuilder();
        b.append((Object)this.getResourceType());
        b.append((Object)this.getHashValue());
        b.append((Object)this.getHashSystem());
        b.append((Object)this.getHashSystemAndValue());
        return b.toHashCode();
    }

    @Override
    public IQueryParameterType toQueryParameterType() {
        return new TokenParam(this.getSystem(), this.getValue());
    }

    public String toString() {
        ToStringBuilder b = new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE);
        b.append("resourceType", (Object)this.getResourceType());
        b.append("paramName", (Object)this.getParamName());
        b.append("system", (Object)this.getSystem());
        b.append("value", (Object)this.getValue());
        b.append("hashIdentity", (Object)this.myHashIdentity);
        return b.build();
    }

    @Override
    public boolean matches(IQueryParameterType theParam, boolean theUseOrdinalDatesForDayComparison) {
        if (!(theParam instanceof TokenParam)) {
            return false;
        }
        TokenParam token = (TokenParam)theParam;
        boolean retVal = false;
        String valueString = StringUtils.defaultString((String)this.getValue());
        String tokenValueString = StringUtils.defaultString((String)token.getValue());
        if (token.getSystem() == null || token.getSystem().isEmpty()) {
            if (valueString.equalsIgnoreCase(tokenValueString)) {
                retVal = true;
            }
        } else if (tokenValueString == null || tokenValueString.isEmpty()) {
            if (token.getSystem().equalsIgnoreCase(this.getSystem())) {
                retVal = true;
            }
        } else if (token.getSystem().equalsIgnoreCase(this.getSystem()) && valueString.equalsIgnoreCase(tokenValueString)) {
            retVal = true;
        }
        return retVal;
    }

    public static long calculateHashSystem(PartitionSettings thePartitionSettings, RequestPartitionId theRequestPartitionId, String theResourceType, String theParamName, String theSystem) {
        return ResourceIndexedSearchParamToken.hash(thePartitionSettings, theRequestPartitionId, theResourceType, theParamName, StringUtils.trim((String)theSystem));
    }

    public static long calculateHashSystemAndValue(PartitionSettings thePartitionSettings, RequestPartitionId theRequestPartitionId, String theResourceType, String theParamName, String theSystem, String theValue) {
        return ResourceIndexedSearchParamToken.hash(thePartitionSettings, theRequestPartitionId, theResourceType, theParamName, StringUtils.defaultString((String)StringUtils.trim((String)theSystem)), StringUtils.trim((String)theValue));
    }

    public static long calculateHashValue(PartitionSettings thePartitionSettings, RequestPartitionId theRequestPartitionId, String theResourceType, String theParamName, String theValue) {
        String value = StringUtils.trim((String)theValue);
        return ResourceIndexedSearchParamToken.hash(thePartitionSettings, theRequestPartitionId, theResourceType, theParamName, value);
    }
}

