/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.model.entity;

import ca.uhn.fhir.jpa.model.entity.BaseResourceIndex;
import ca.uhn.fhir.jpa.model.entity.ResourceTable;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.hibernate.search.annotations.Field;
import org.hl7.fhir.instance.model.api.IIdType;

@Entity
@Table(name="HFJ_RES_LINK", indexes={@Index(name="IDX_RL_TPATHRES", columnList="SRC_PATH,TARGET_RESOURCE_ID"), @Index(name="IDX_RL_SRC", columnList="SRC_RESOURCE_ID"), @Index(name="IDX_RL_DEST", columnList="TARGET_RESOURCE_ID")})
public class ResourceLink
extends BaseResourceIndex {
    public static final int SRC_PATH_LENGTH = 200;
    private static final long serialVersionUID = 1L;
    @SequenceGenerator(name="SEQ_RESLINK_ID", sequenceName="SEQ_RESLINK_ID")
    @GeneratedValue(strategy=GenerationType.AUTO, generator="SEQ_RESLINK_ID")
    @Id
    @Column(name="PID")
    private Long myId;
    @Column(name="SRC_PATH", length=200, nullable=false)
    private String mySourcePath;
    @ManyToOne(optional=false, fetch=FetchType.LAZY)
    @JoinColumn(name="SRC_RESOURCE_ID", referencedColumnName="RES_ID", nullable=false, foreignKey=@ForeignKey(name="FK_RESLINK_SOURCE"))
    private ResourceTable mySourceResource;
    @Column(name="SRC_RESOURCE_ID", insertable=false, updatable=false, nullable=false)
    private Long mySourceResourcePid;
    @Column(name="SOURCE_RESOURCE_TYPE", updatable=false, nullable=false, length=40)
    @Field
    private String mySourceResourceType;
    @ManyToOne(optional=true, fetch=FetchType.LAZY)
    @JoinColumn(name="TARGET_RESOURCE_ID", referencedColumnName="RES_ID", nullable=true, insertable=false, updatable=false, foreignKey=@ForeignKey(name="FK_RESLINK_TARGET"))
    private ResourceTable myTargetResource;
    @Column(name="TARGET_RESOURCE_ID", insertable=true, updatable=true, nullable=true)
    @Field
    private Long myTargetResourcePid;
    @Column(name="TARGET_RESOURCE_TYPE", nullable=false, length=40)
    @Field
    private String myTargetResourceType;
    @Column(name="TARGET_RESOURCE_URL", length=200, nullable=true)
    @Field
    private String myTargetResourceUrl;
    @Field
    @Column(name="SP_UPDATED", nullable=true)
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date myUpdated;
    @Transient
    private transient String myTargetResourceId;

    public String getTargetResourceId() {
        if (this.myTargetResourceId == null && this.myTargetResource != null) {
            this.myTargetResourceId = this.getTargetResource().getIdDt().getIdPart();
        }
        return this.myTargetResourceId;
    }

    public String getTargetResourceType() {
        return this.myTargetResourceType;
    }

    @Override
    public boolean equals(Object theObj) {
        if (this == theObj) {
            return true;
        }
        if (theObj == null) {
            return false;
        }
        if (!(theObj instanceof ResourceLink)) {
            return false;
        }
        ResourceLink obj = (ResourceLink)theObj;
        EqualsBuilder b = new EqualsBuilder();
        b.append((Object)this.mySourcePath, (Object)obj.mySourcePath);
        b.append((Object)this.mySourceResource, (Object)obj.mySourceResource);
        b.append((Object)this.myTargetResourceUrl, (Object)obj.myTargetResourceUrl);
        b.append((Object)this.myTargetResourceType, (Object)obj.myTargetResourceType);
        b.append((Object)this.getTargetResourceId(), (Object)obj.getTargetResourceId());
        return b.isEquals();
    }

    @Override
    public <T extends BaseResourceIndex> void copyMutableValuesFrom(T theSource) {
        ResourceLink source = (ResourceLink)theSource;
        this.mySourcePath = source.getSourcePath();
        this.myTargetResource = source.getTargetResource();
        this.myTargetResourceId = source.getTargetResourceId();
        this.myTargetResourcePid = source.getTargetResourcePid();
        this.myTargetResourceType = source.getTargetResourceType();
        this.myTargetResourceUrl = source.getTargetResourceUrl();
    }

    public String getSourcePath() {
        return this.mySourcePath;
    }

    public void setSourcePath(String theSourcePath) {
        this.mySourcePath = theSourcePath;
    }

    public Long getSourceResourcePid() {
        return this.mySourceResourcePid;
    }

    public ResourceTable getSourceResource() {
        return this.mySourceResource;
    }

    public void setSourceResource(ResourceTable theSourceResource) {
        this.mySourceResource = theSourceResource;
        this.mySourceResourcePid = theSourceResource.getId();
        this.mySourceResourceType = theSourceResource.getResourceType();
    }

    public void setTargetResource(String theResourceType, Long theResourcePid, String theTargetResourceId) {
        Validate.notBlank((CharSequence)theResourceType);
        this.myTargetResourceType = theResourceType;
        this.myTargetResourcePid = theResourcePid;
        this.myTargetResourceId = theTargetResourceId;
    }

    public String getTargetResourceUrl() {
        return this.myTargetResourceUrl;
    }

    public Long getTargetResourcePid() {
        return this.myTargetResourcePid;
    }

    public void setTargetResourceUrl(IIdType theTargetResourceUrl) {
        Validate.isTrue((boolean)theTargetResourceUrl.hasBaseUrl());
        Validate.isTrue((boolean)theTargetResourceUrl.hasResourceType());
        this.myTargetResourceType = theTargetResourceUrl.getResourceType();
        this.myTargetResourceUrl = theTargetResourceUrl.getValue();
    }

    public void setTargetResourceUrlCanonical(String theTargetResourceUrl) {
        Validate.notBlank((CharSequence)theTargetResourceUrl);
        this.myTargetResourceType = "(unknown)";
        this.myTargetResourceUrl = theTargetResourceUrl;
    }

    public Date getUpdated() {
        return this.myUpdated;
    }

    public void setUpdated(Date theUpdated) {
        this.myUpdated = theUpdated;
    }

    @Override
    public Long getId() {
        return this.myId;
    }

    @Override
    public void setId(Long theId) {
        this.myId = theId;
    }

    @Override
    public void calculateHashes() {
    }

    @Override
    public int hashCode() {
        HashCodeBuilder b = new HashCodeBuilder();
        b.append((Object)this.mySourcePath);
        b.append((Object)this.mySourceResource);
        b.append((Object)this.myTargetResourceUrl);
        b.append((Object)this.getTargetResourceType());
        b.append((Object)this.getTargetResourceId());
        return b.toHashCode();
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("ResourceLink[");
        b.append("path=").append(this.mySourcePath);
        b.append(", src=").append(this.mySourceResourcePid);
        b.append(", target=").append(this.myTargetResourcePid);
        b.append(", targetType=").append(this.myTargetResourceType);
        b.append(", targetUrl=").append(this.myTargetResourceUrl);
        b.append("]");
        return b.toString();
    }

    public ResourceTable getTargetResource() {
        return this.myTargetResource;
    }

    public static ResourceLink forAbsoluteReference(String theSourcePath, ResourceTable theSourceResource, IIdType theTargetResourceUrl, Date theUpdated) {
        ResourceLink retVal = new ResourceLink();
        retVal.setSourcePath(theSourcePath);
        retVal.setSourceResource(theSourceResource);
        retVal.setTargetResourceUrl(theTargetResourceUrl);
        retVal.setUpdated(theUpdated);
        return retVal;
    }

    public static ResourceLink forLogicalReference(String theSourcePath, ResourceTable theSourceResource, String theTargetResourceUrl, Date theUpdated) {
        ResourceLink retVal = new ResourceLink();
        retVal.setSourcePath(theSourcePath);
        retVal.setSourceResource(theSourceResource);
        retVal.setTargetResourceUrlCanonical(theTargetResourceUrl);
        retVal.setUpdated(theUpdated);
        return retVal;
    }

    public static ResourceLink forLocalReference(String theSourcePath, ResourceTable theSourceResource, String theTargetResourceType, Long theTargetResourcePid, String theTargetResourceId, Date theUpdated) {
        ResourceLink retVal = new ResourceLink();
        retVal.setSourcePath(theSourcePath);
        retVal.setSourceResource(theSourceResource);
        retVal.setTargetResource(theTargetResourceType, theTargetResourcePid, theTargetResourceId);
        retVal.setUpdated(theUpdated);
        return retVal;
    }
}

