/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.model.entity;

import ca.uhn.fhir.jpa.model.cross.IBasePersistedResource;
import ca.uhn.fhir.jpa.model.cross.IResourceLookup;
import ca.uhn.fhir.jpa.model.entity.BaseHasResource;
import ca.uhn.fhir.jpa.model.entity.ForcedId;
import ca.uhn.fhir.jpa.model.entity.ResourceHistoryProvenanceEntity;
import ca.uhn.fhir.jpa.model.entity.ResourceHistoryTable;
import ca.uhn.fhir.jpa.model.entity.ResourceIndexedCompositeStringUnique;
import ca.uhn.fhir.jpa.model.entity.ResourceIndexedSearchParamCoords;
import ca.uhn.fhir.jpa.model.entity.ResourceIndexedSearchParamDate;
import ca.uhn.fhir.jpa.model.entity.ResourceIndexedSearchParamNumber;
import ca.uhn.fhir.jpa.model.entity.ResourceIndexedSearchParamQuantity;
import ca.uhn.fhir.jpa.model.entity.ResourceIndexedSearchParamString;
import ca.uhn.fhir.jpa.model.entity.ResourceIndexedSearchParamToken;
import ca.uhn.fhir.jpa.model.entity.ResourceIndexedSearchParamUri;
import ca.uhn.fhir.jpa.model.entity.ResourceLink;
import ca.uhn.fhir.jpa.model.entity.ResourceTag;
import ca.uhn.fhir.jpa.model.entity.SearchParamPresent;
import ca.uhn.fhir.jpa.model.entity.TagDefinition;
import ca.uhn.fhir.jpa.model.search.IndexNonDeletedInterceptor;
import ca.uhn.fhir.model.primitive.IdDt;
import ca.uhn.fhir.rest.api.server.storage.ResourcePersistentId;
import ca.uhn.fhir.rest.server.exceptions.UnprocessableEntityException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.PrePersist;
import javax.persistence.PreUpdate;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.persistence.Version;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.hibernate.annotations.OptimisticLock;
import org.hibernate.search.annotations.Analyze;
import org.hibernate.search.annotations.Analyzer;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.Fields;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.annotations.Store;

@Indexed(interceptor=IndexNonDeletedInterceptor.class)
@Entity
@Table(name="HFJ_RESOURCE", uniqueConstraints={}, indexes={@Index(name="IDX_RES_DATE", columnList="RES_UPDATED"), @Index(name="IDX_RES_LANG", columnList="RES_TYPE,RES_LANGUAGE"), @Index(name="IDX_RES_TYPE", columnList="RES_TYPE"), @Index(name="IDX_INDEXSTATUS", columnList="SP_INDEX_STATUS")})
public class ResourceTable
extends BaseHasResource
implements Serializable,
IBasePersistedResource,
IResourceLookup {
    public static final int RESTYPE_LEN = 40;
    private static final int MAX_LANGUAGE_LENGTH = 20;
    private static final long serialVersionUID = 1L;
    @Transient
    @Fields(value={@Field(name="myContentText", index=org.hibernate.search.annotations.Index.YES, store=Store.YES, analyze=Analyze.YES, analyzer=@Analyzer(definition="standardAnalyzer")), @Field(name="myContentTextEdgeNGram", index=org.hibernate.search.annotations.Index.YES, store=Store.NO, analyze=Analyze.YES, analyzer=@Analyzer(definition="autocompleteEdgeAnalyzer")), @Field(name="myContentTextNGram", index=org.hibernate.search.annotations.Index.YES, store=Store.NO, analyze=Analyze.YES, analyzer=@Analyzer(definition="autocompleteNGramAnalyzer")), @Field(name="myContentTextPhonetic", index=org.hibernate.search.annotations.Index.YES, store=Store.NO, analyze=Analyze.YES, analyzer=@Analyzer(definition="autocompletePhoneticAnalyzer"))})
    @OptimisticLock(excluded=true)
    private String myContentText;
    @Column(name="HASH_SHA256", length=64, nullable=true)
    @OptimisticLock(excluded=true)
    private String myHashSha256;
    @Column(name="SP_HAS_LINKS")
    @OptimisticLock(excluded=true)
    private boolean myHasLinks;
    @Id
    @SequenceGenerator(name="SEQ_RESOURCE_ID", sequenceName="SEQ_RESOURCE_ID")
    @GeneratedValue(strategy=GenerationType.AUTO, generator="SEQ_RESOURCE_ID")
    @Column(name="RES_ID")
    private Long myId;
    @Column(name="SP_INDEX_STATUS", nullable=true)
    @OptimisticLock(excluded=true)
    private Long myIndexStatus;
    @Column(name="RES_LANGUAGE", length=20, nullable=true)
    @OptimisticLock(excluded=true)
    private String myLanguage;
    @Transient
    @Fields(value={@Field(name="myNarrativeText", index=org.hibernate.search.annotations.Index.YES, store=Store.YES, analyze=Analyze.YES, analyzer=@Analyzer(definition="standardAnalyzer")), @Field(name="myNarrativeTextEdgeNGram", index=org.hibernate.search.annotations.Index.YES, store=Store.NO, analyze=Analyze.YES, analyzer=@Analyzer(definition="autocompleteEdgeAnalyzer")), @Field(name="myNarrativeTextNGram", index=org.hibernate.search.annotations.Index.YES, store=Store.NO, analyze=Analyze.YES, analyzer=@Analyzer(definition="autocompleteNGramAnalyzer")), @Field(name="myNarrativeTextPhonetic", index=org.hibernate.search.annotations.Index.YES, store=Store.NO, analyze=Analyze.YES, analyzer=@Analyzer(definition="autocompletePhoneticAnalyzer"))})
    @OptimisticLock(excluded=true)
    private String myNarrativeText;
    @OneToMany(mappedBy="myResource", cascade={}, fetch=FetchType.LAZY, orphanRemoval=false)
    @OptimisticLock(excluded=true)
    private Collection<ResourceIndexedSearchParamCoords> myParamsCoords;
    @Column(name="SP_COORDS_PRESENT")
    @OptimisticLock(excluded=true)
    private boolean myParamsCoordsPopulated;
    @OneToMany(mappedBy="myResource", cascade={}, fetch=FetchType.LAZY, orphanRemoval=false)
    @OptimisticLock(excluded=true)
    private Collection<ResourceIndexedSearchParamDate> myParamsDate;
    @Column(name="SP_DATE_PRESENT")
    @OptimisticLock(excluded=true)
    private boolean myParamsDatePopulated;
    @OptimisticLock(excluded=true)
    @OneToMany(mappedBy="myResource", cascade={}, fetch=FetchType.LAZY, orphanRemoval=false)
    private Collection<ResourceIndexedSearchParamNumber> myParamsNumber;
    @Column(name="SP_NUMBER_PRESENT")
    @OptimisticLock(excluded=true)
    private boolean myParamsNumberPopulated;
    @OneToMany(mappedBy="myResource", cascade={}, fetch=FetchType.LAZY, orphanRemoval=false)
    @OptimisticLock(excluded=true)
    private Collection<ResourceIndexedSearchParamQuantity> myParamsQuantity;
    @Column(name="SP_QUANTITY_PRESENT")
    @OptimisticLock(excluded=true)
    private boolean myParamsQuantityPopulated;
    @OneToMany(mappedBy="myResource", cascade={}, fetch=FetchType.LAZY, orphanRemoval=false)
    @OptimisticLock(excluded=true)
    private Collection<ResourceIndexedSearchParamString> myParamsString;
    @Column(name="SP_STRING_PRESENT")
    @OptimisticLock(excluded=true)
    private boolean myParamsStringPopulated;
    @OneToMany(mappedBy="myResource", cascade={}, fetch=FetchType.LAZY, orphanRemoval=false)
    @OptimisticLock(excluded=true)
    private Collection<ResourceIndexedSearchParamToken> myParamsToken;
    @Column(name="SP_TOKEN_PRESENT")
    @OptimisticLock(excluded=true)
    private boolean myParamsTokenPopulated;
    @OneToMany(mappedBy="myResource", cascade={}, fetch=FetchType.LAZY, orphanRemoval=false)
    @OptimisticLock(excluded=true)
    private Collection<ResourceIndexedSearchParamUri> myParamsUri;
    @Column(name="SP_URI_PRESENT")
    @OptimisticLock(excluded=true)
    private boolean myParamsUriPopulated;
    @OptimisticLock(excluded=true)
    @Column(name="SP_CMPSTR_UNIQ_PRESENT")
    private Boolean myParamsCompositeStringUniquePresent = false;
    @OneToMany(mappedBy="myResource", cascade={}, fetch=FetchType.LAZY, orphanRemoval=false)
    @OptimisticLock(excluded=true)
    private Collection<ResourceIndexedCompositeStringUnique> myParamsCompositeStringUnique;
    @OneToMany(mappedBy="mySourceResource", cascade={}, fetch=FetchType.LAZY, orphanRemoval=false)
    @OptimisticLock(excluded=true)
    private Collection<ResourceLink> myResourceLinks;
    @Field
    @Transient
    private String myResourceLinksField;
    @OneToMany(mappedBy="myTargetResource", cascade={}, fetch=FetchType.LAZY, orphanRemoval=false)
    @OptimisticLock(excluded=true)
    private Collection<ResourceLink> myResourceLinksAsTarget;
    @Column(name="RES_TYPE", length=40, nullable=false)
    @Field
    @OptimisticLock(excluded=true)
    private String myResourceType;
    @OneToMany(mappedBy="myResource", cascade={CascadeType.ALL}, fetch=FetchType.LAZY, orphanRemoval=true)
    @OptimisticLock(excluded=true)
    private Collection<SearchParamPresent> mySearchParamPresents;
    @OneToMany(mappedBy="myResource", cascade={CascadeType.ALL}, fetch=FetchType.LAZY, orphanRemoval=true)
    @OptimisticLock(excluded=true)
    private Set<ResourceTag> myTags;
    @Transient
    private transient boolean myUnchangedInCurrentOperation;
    @Version
    @Column(name="RES_VER")
    private long myVersion;
    @OneToMany(mappedBy="myResourceTable", fetch=FetchType.LAZY)
    private Collection<ResourceHistoryProvenanceEntity> myProvenance;
    @Transient
    private transient ResourceHistoryTable myCurrentVersionEntity;
    @OneToOne(optional=true, fetch=FetchType.EAGER, cascade={}, orphanRemoval=false, mappedBy="myResource")
    private ForcedId myForcedId;

    @Override
    public ResourceTag addTag(TagDefinition theTag) {
        for (ResourceTag next : this.getTags()) {
            if (!next.getTag().equals(theTag)) continue;
            return next;
        }
        ResourceTag tag = new ResourceTag(this, theTag, this.getPartitionId());
        this.getTags().add(tag);
        return tag;
    }

    public String getHashSha256() {
        return this.myHashSha256;
    }

    public void setHashSha256(String theHashSha256) {
        this.myHashSha256 = theHashSha256;
    }

    @Override
    public Long getId() {
        return this.myId;
    }

    public void setId(Long theId) {
        this.myId = theId;
    }

    public Long getIndexStatus() {
        return this.myIndexStatus;
    }

    public void setIndexStatus(Long theIndexStatus) {
        this.myIndexStatus = theIndexStatus;
    }

    public String getLanguage() {
        return this.myLanguage;
    }

    public void setLanguage(String theLanguage) {
        if (StringUtils.defaultString((String)theLanguage).length() > 20) {
            throw new UnprocessableEntityException("Language exceeds maximum length of 20 chars: " + theLanguage);
        }
        this.myLanguage = theLanguage;
    }

    public Collection<ResourceIndexedCompositeStringUnique> getParamsCompositeStringUnique() {
        if (this.myParamsCompositeStringUnique == null) {
            this.myParamsCompositeStringUnique = new ArrayList<ResourceIndexedCompositeStringUnique>();
        }
        return this.myParamsCompositeStringUnique;
    }

    public Collection<ResourceIndexedSearchParamCoords> getParamsCoords() {
        if (this.myParamsCoords == null) {
            this.myParamsCoords = new ArrayList<ResourceIndexedSearchParamCoords>();
        }
        return this.myParamsCoords;
    }

    public void setParamsCoords(Collection<ResourceIndexedSearchParamCoords> theParamsCoords) {
        if (!this.isParamsTokenPopulated() && theParamsCoords.isEmpty()) {
            return;
        }
        this.getParamsCoords().clear();
        this.getParamsCoords().addAll(theParamsCoords);
    }

    public Collection<ResourceIndexedSearchParamDate> getParamsDate() {
        if (this.myParamsDate == null) {
            this.myParamsDate = new ArrayList<ResourceIndexedSearchParamDate>();
        }
        return this.myParamsDate;
    }

    public void setParamsDate(Collection<ResourceIndexedSearchParamDate> theParamsDate) {
        if (!this.isParamsDatePopulated() && theParamsDate.isEmpty()) {
            return;
        }
        this.getParamsDate().clear();
        this.getParamsDate().addAll(theParamsDate);
    }

    public Collection<ResourceIndexedSearchParamNumber> getParamsNumber() {
        if (this.myParamsNumber == null) {
            this.myParamsNumber = new ArrayList<ResourceIndexedSearchParamNumber>();
        }
        return this.myParamsNumber;
    }

    public void setParamsNumber(Collection<ResourceIndexedSearchParamNumber> theNumberParams) {
        if (!this.isParamsNumberPopulated() && theNumberParams.isEmpty()) {
            return;
        }
        this.getParamsNumber().clear();
        this.getParamsNumber().addAll(theNumberParams);
    }

    public Collection<ResourceIndexedSearchParamQuantity> getParamsQuantity() {
        if (this.myParamsQuantity == null) {
            this.myParamsQuantity = new ArrayList<ResourceIndexedSearchParamQuantity>();
        }
        return this.myParamsQuantity;
    }

    public void setParamsQuantity(Collection<ResourceIndexedSearchParamQuantity> theQuantityParams) {
        if (!this.isParamsQuantityPopulated() && theQuantityParams.isEmpty()) {
            return;
        }
        this.getParamsQuantity().clear();
        this.getParamsQuantity().addAll(theQuantityParams);
    }

    public Collection<ResourceIndexedSearchParamString> getParamsString() {
        if (this.myParamsString == null) {
            this.myParamsString = new ArrayList<ResourceIndexedSearchParamString>();
        }
        return this.myParamsString;
    }

    public void setParamsString(Collection<ResourceIndexedSearchParamString> theParamsString) {
        if (!this.isParamsStringPopulated() && theParamsString.isEmpty()) {
            return;
        }
        this.getParamsString().clear();
        this.getParamsString().addAll(theParamsString);
    }

    public Collection<ResourceIndexedSearchParamToken> getParamsToken() {
        if (this.myParamsToken == null) {
            this.myParamsToken = new ArrayList<ResourceIndexedSearchParamToken>();
        }
        return this.myParamsToken;
    }

    public void setParamsToken(Collection<ResourceIndexedSearchParamToken> theParamsToken) {
        if (!this.isParamsTokenPopulated() && theParamsToken.isEmpty()) {
            return;
        }
        this.getParamsToken().clear();
        this.getParamsToken().addAll(theParamsToken);
    }

    public Collection<ResourceIndexedSearchParamUri> getParamsUri() {
        if (this.myParamsUri == null) {
            this.myParamsUri = new ArrayList<ResourceIndexedSearchParamUri>();
        }
        return this.myParamsUri;
    }

    public void setParamsUri(Collection<ResourceIndexedSearchParamUri> theParamsUri) {
        if (!this.isParamsTokenPopulated() && theParamsUri.isEmpty()) {
            return;
        }
        this.getParamsUri().clear();
        this.getParamsUri().addAll(theParamsUri);
    }

    @Override
    public Long getResourceId() {
        return this.getId();
    }

    public Collection<ResourceLink> getResourceLinks() {
        if (this.myResourceLinks == null) {
            this.myResourceLinks = new ArrayList<ResourceLink>();
        }
        return this.myResourceLinks;
    }

    public void setResourceLinks(Collection<ResourceLink> theLinks) {
        if (!this.isHasLinks() && theLinks.isEmpty()) {
            return;
        }
        this.getResourceLinks().clear();
        this.getResourceLinks().addAll(theLinks);
    }

    @Override
    public String getResourceType() {
        return this.myResourceType;
    }

    public ResourceTable setResourceType(String theResourceType) {
        this.myResourceType = theResourceType;
        return this;
    }

    public Collection<ResourceTag> getTags() {
        if (this.myTags == null) {
            this.myTags = new HashSet<ResourceTag>();
        }
        return this.myTags;
    }

    @Override
    public long getVersion() {
        return this.myVersion;
    }

    public void setVersion(long theVersion) {
        this.myVersion = theVersion;
    }

    public boolean isHasLinks() {
        return this.myHasLinks;
    }

    public void setHasLinks(boolean theHasLinks) {
        this.myHasLinks = theHasLinks;
    }

    public boolean isParamsCompositeStringUniquePresent() {
        if (this.myParamsCompositeStringUniquePresent == null) {
            return false;
        }
        return this.myParamsCompositeStringUniquePresent;
    }

    public void setParamsCompositeStringUniquePresent(boolean theParamsCompositeStringUniquePresent) {
        this.myParamsCompositeStringUniquePresent = theParamsCompositeStringUniquePresent;
    }

    public boolean isParamsCoordsPopulated() {
        return this.myParamsCoordsPopulated;
    }

    public void setParamsCoordsPopulated(boolean theParamsCoordsPopulated) {
        this.myParamsCoordsPopulated = theParamsCoordsPopulated;
    }

    public boolean isParamsDatePopulated() {
        return this.myParamsDatePopulated;
    }

    public void setParamsDatePopulated(boolean theParamsDatePopulated) {
        this.myParamsDatePopulated = theParamsDatePopulated;
    }

    public boolean isParamsNumberPopulated() {
        return this.myParamsNumberPopulated;
    }

    public void setParamsNumberPopulated(boolean theParamsNumberPopulated) {
        this.myParamsNumberPopulated = theParamsNumberPopulated;
    }

    public boolean isParamsQuantityPopulated() {
        return this.myParamsQuantityPopulated;
    }

    public void setParamsQuantityPopulated(boolean theParamsQuantityPopulated) {
        this.myParamsQuantityPopulated = theParamsQuantityPopulated;
    }

    public boolean isParamsStringPopulated() {
        return this.myParamsStringPopulated;
    }

    public void setParamsStringPopulated(boolean theParamsStringPopulated) {
        this.myParamsStringPopulated = theParamsStringPopulated;
    }

    public boolean isParamsTokenPopulated() {
        return this.myParamsTokenPopulated;
    }

    public void setParamsTokenPopulated(boolean theParamsTokenPopulated) {
        this.myParamsTokenPopulated = theParamsTokenPopulated;
    }

    public boolean isParamsUriPopulated() {
        return this.myParamsUriPopulated;
    }

    public void setParamsUriPopulated(boolean theParamsUriPopulated) {
        this.myParamsUriPopulated = theParamsUriPopulated;
    }

    public boolean isUnchangedInCurrentOperation() {
        return this.myUnchangedInCurrentOperation;
    }

    public void setUnchangedInCurrentOperation(boolean theUnchangedInCurrentOperation) {
        this.myUnchangedInCurrentOperation = theUnchangedInCurrentOperation;
    }

    public void setContentTextParsedIntoWords(String theContentText) {
        this.myContentText = theContentText;
    }

    public void setNarrativeTextParsedIntoWords(String theNarrativeText) {
        this.myNarrativeText = theNarrativeText;
    }

    public ResourceHistoryTable toHistory() {
        ResourceHistoryTable retVal = new ResourceHistoryTable();
        retVal.setResourceId(this.myId);
        retVal.setResourceType(this.myResourceType);
        retVal.setVersion(this.myVersion);
        retVal.setTransientForcedId(this.getTransientForcedId());
        retVal.setPublished(this.getPublished());
        retVal.setUpdated(this.getUpdated());
        retVal.setFhirVersion(this.getFhirVersion());
        retVal.setDeleted(this.getDeleted());
        retVal.setResourceTable(this);
        retVal.setForcedId(this.getForcedId());
        retVal.setPartitionId(this.getPartitionId());
        retVal.getTags().clear();
        retVal.setHasTags(this.isHasTags());
        if (this.isHasTags()) {
            for (ResourceTag next : this.getTags()) {
                retVal.addTag(next);
            }
        }
        return retVal;
    }

    public String toString() {
        ToStringBuilder b = new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE);
        b.append("pid", (Object)this.myId);
        b.append("resourceType", (Object)this.myResourceType);
        if (this.getDeleted() != null) {
            b.append((Object)"deleted");
        }
        return b.build();
    }

    @PrePersist
    @PreUpdate
    public void preSave() {
        this.myResourceLinksField = this.myHasLinks && this.myResourceLinks != null ? this.getResourceLinks().stream().map(ResourceLink::getTargetResourcePid).filter(Objects::nonNull).map(Object::toString).collect(Collectors.joining(" ")) : null;
    }

    public void setCurrentVersionEntity(ResourceHistoryTable theCurrentVersionEntity) {
        this.myCurrentVersionEntity = theCurrentVersionEntity;
    }

    public ResourceHistoryTable getCurrentVersionEntity() {
        return this.myCurrentVersionEntity;
    }

    @Override
    public ResourcePersistentId getPersistentId() {
        return new ResourcePersistentId((Object)this.getId());
    }

    @Override
    public ForcedId getForcedId() {
        return this.myForcedId;
    }

    @Override
    public void setForcedId(ForcedId theForcedId) {
        this.myForcedId = theForcedId;
    }

    @Override
    public IdDt getIdDt() {
        if (this.getForcedId() == null) {
            Long id = this.getResourceId();
            return new IdDt(this.getResourceType() + '/' + id + '/' + "_history" + '/' + this.getVersion());
        }
        String forcedId = this.getTransientForcedId() != null ? this.getTransientForcedId() : this.getForcedId().getForcedId();
        return new IdDt(this.getResourceType() + '/' + forcedId + '/' + "_history" + '/' + this.getVersion());
    }
}

