/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.model.entity;

import ca.uhn.fhir.interceptor.model.RequestPartitionId;
import ca.uhn.fhir.jpa.model.config.PartitionSettings;
import ca.uhn.fhir.jpa.model.entity.BasePartitionable;
import ca.uhn.fhir.jpa.model.entity.BaseResourceIndexedSearchParam;
import ca.uhn.fhir.jpa.model.entity.ResourceTable;
import java.io.Serializable;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.PrePersist;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

@Entity
@Table(name="HFJ_RES_PARAM_PRESENT", indexes={@Index(name="IDX_RESPARMPRESENT_RESID", columnList="RES_ID"), @Index(name="IDX_RESPARMPRESENT_HASHPRES", columnList="HASH_PRESENCE")})
public class SearchParamPresent
extends BasePartitionable
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Id
    @SequenceGenerator(name="SEQ_RESPARMPRESENT_ID", sequenceName="SEQ_RESPARMPRESENT_ID")
    @GeneratedValue(strategy=GenerationType.AUTO, generator="SEQ_RESPARMPRESENT_ID")
    @Column(name="PID")
    private Long myId;
    @Column(name="SP_PRESENT", nullable=false)
    private boolean myPresent;
    @ManyToOne
    @JoinColumn(name="RES_ID", referencedColumnName="RES_ID", nullable=false, foreignKey=@ForeignKey(name="FK_RESPARMPRES_RESID"))
    private ResourceTable myResource;
    @Column(name="RES_ID", nullable=false, insertable=false, updatable=false)
    private Long myResourcePid;
    @Transient
    private transient String myParamName;
    @Column(name="HASH_PRESENCE")
    private Long myHashPresence;
    @Transient
    private transient PartitionSettings myPartitionSettings;

    @PrePersist
    public void calculateHashes() {
        if (this.myHashPresence == null && this.getParamName() != null) {
            String resourceType = this.getResource().getResourceType();
            String paramName = this.getParamName();
            boolean present = this.myPresent;
            this.setHashPresence(SearchParamPresent.calculateHashPresence(this.getPartitionSettings(), this.getPartitionId(), resourceType, paramName, present));
        }
    }

    public Long getHashPresence() {
        return this.myHashPresence;
    }

    public void setHashPresence(Long theHashPresence) {
        this.myHashPresence = theHashPresence;
    }

    public String getParamName() {
        return this.myParamName;
    }

    public void setParamName(String theParamName) {
        this.myParamName = theParamName;
    }

    public ResourceTable getResource() {
        return this.myResource;
    }

    public void setResource(ResourceTable theResourceTable) {
        this.myResource = theResourceTable;
    }

    public boolean isPresent() {
        return this.myPresent;
    }

    public void setPresent(boolean thePresent) {
        this.myPresent = thePresent;
    }

    public String toString() {
        ToStringBuilder b = new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE);
        b.append("resPid", (Object)this.myResource.getIdDt().toUnqualifiedVersionless().getValue());
        b.append("paramName", (Object)this.myParamName);
        b.append("present", this.myPresent);
        b.append("partition", (Object)this.getPartitionId());
        return b.build();
    }

    public PartitionSettings getPartitionSettings() {
        return this.myPartitionSettings;
    }

    public void setPartitionSettings(PartitionSettings thePartitionSettings) {
        this.myPartitionSettings = thePartitionSettings;
    }

    public static long calculateHashPresence(PartitionSettings thePartitionSettings, RequestPartitionId theRequestPartitionId, String theResourceType, String theParamName, Boolean thePresent) {
        String string = thePresent != null ? Boolean.toString(thePresent) : Boolean.toString(false);
        return BaseResourceIndexedSearchParam.hash(thePartitionSettings, theRequestPartitionId, theResourceType, theParamName, string);
    }
}

