/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.model.search;

import ca.uhn.fhir.jpa.model.entity.ResourceTable;
import org.hibernate.search.indexes.interceptor.EntityIndexingInterceptor;
import org.hibernate.search.indexes.interceptor.IndexingOverride;

public class IndexNonDeletedInterceptor
implements EntityIndexingInterceptor<ResourceTable> {
    public IndexingOverride onAdd(ResourceTable entity) {
        if (entity.getDeleted() == null && entity.getIndexStatus() != null) {
            return IndexingOverride.APPLY_DEFAULT;
        }
        return IndexingOverride.SKIP;
    }

    public IndexingOverride onUpdate(ResourceTable entity) {
        if (entity.getIndexStatus() == null) {
            return IndexingOverride.SKIP;
        }
        if (entity.getDeleted() == null) {
            return IndexingOverride.UPDATE;
        }
        return IndexingOverride.REMOVE;
    }

    public IndexingOverride onDelete(ResourceTable entity) {
        return IndexingOverride.APPLY_DEFAULT;
    }

    public IndexingOverride onCollectionUpdate(ResourceTable entity) {
        return IndexingOverride.APPLY_DEFAULT;
    }
}

