/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.model.dao;

import ca.uhn.fhir.rest.api.server.storage.BaseResourcePersistentId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

public class JpaPid
extends BaseResourcePersistentId<Long> {
    private final Long myId;

    private JpaPid(Long theId) {
        super(null);
        this.myId = theId;
    }

    private JpaPid(Long theId, Long theVersion) {
        super(theVersion, null);
        this.myId = theId;
    }

    private JpaPid(Long theId, String theResourceType) {
        super(theResourceType);
        this.myId = theId;
    }

    private JpaPid(Long theId, Long theVersion, String theResourceType) {
        super(theVersion, theResourceType);
        this.myId = theId;
    }

    public static List<Long> toLongList(Collection<JpaPid> thePids) {
        ArrayList<Long> retVal = new ArrayList<Long>(thePids.size());
        for (JpaPid next : thePids) {
            retVal.add(next.getId());
        }
        return retVal;
    }

    public static Set<Long> toLongSet(Collection<JpaPid> thePids) {
        HashSet<Long> retVal = new HashSet<Long>(thePids.size());
        for (JpaPid next : thePids) {
            retVal.add(next.getId());
        }
        return retVal;
    }

    public static List<JpaPid> fromLongList(Collection<Long> theResultList) {
        ArrayList<JpaPid> retVal = new ArrayList<JpaPid>(theResultList.size());
        for (Long next : theResultList) {
            retVal.add(JpaPid.fromId(next));
        }
        return retVal;
    }

    public static JpaPid fromId(Long theId) {
        return new JpaPid(theId);
    }

    public static JpaPid fromIdAndVersion(Long theId, Long theVersion) {
        return new JpaPid(theId, theVersion);
    }

    public static JpaPid fromIdAndResourceType(Long theId, String theResourceType) {
        return new JpaPid(theId, theResourceType);
    }

    public static JpaPid fromIdAndVersionAndResourceType(Long theId, Long theVersion, String theResourceType) {
        return new JpaPid(theId, theVersion, theResourceType);
    }

    public boolean equals(Object theO) {
        if (this == theO) {
            return true;
        }
        if (theO == null || ((Object)((Object)this)).getClass() != theO.getClass()) {
            return false;
        }
        if (!super.equals(theO)) {
            return false;
        }
        JpaPid jpaPid = (JpaPid)((Object)theO);
        return this.myId.equals(jpaPid.myId);
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.myId);
    }

    public Long getId() {
        return this.myId;
    }

    public String toString() {
        return this.myId.toString();
    }
}

