/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.model.entity;

import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.interceptor.model.RequestPartitionId;
import ca.uhn.fhir.jpa.model.config.PartitionSettings;
import ca.uhn.fhir.jpa.model.entity.BaseResourceIndex;
import ca.uhn.fhir.jpa.model.entity.PartitionablePartitionId;
import ca.uhn.fhir.jpa.model.entity.ResourceTable;
import ca.uhn.fhir.jpa.model.entity.StorageSettings;
import ca.uhn.fhir.model.api.IQueryParameterType;
import ca.uhn.fhir.rest.server.exceptions.InternalErrorException;
import ca.uhn.fhir.util.UrlUtil;
import com.google.common.base.Charsets;
import com.google.common.hash.HashCode;
import com.google.common.hash.HashFunction;
import com.google.common.hash.Hasher;
import com.google.common.hash.Hashing;
import jakarta.persistence.Column;
import jakarta.persistence.MappedSuperclass;
import jakarta.persistence.Temporal;
import jakarta.persistence.TemporalType;
import jakarta.persistence.Transient;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.search.mapper.pojo.mapping.definition.annotation.FullTextField;
import org.hibernate.search.mapper.pojo.mapping.definition.annotation.GenericField;

@MappedSuperclass
public abstract class BaseResourceIndexedSearchParam
extends BaseResourceIndex {
    static final int MAX_SP_NAME = 100;
    private static final HashFunction HASH_FUNCTION = Hashing.murmur3_128((int)0);
    private static final byte[] DELIMITER_BYTES = "|".getBytes(Charsets.UTF_8);
    private static final long serialVersionUID = 1L;
    @GenericField
    @Column(name="SP_MISSING", nullable=false)
    private boolean myMissing = false;
    @FullTextField
    @Column(name="SP_NAME", length=100, nullable=false)
    private String myParamName;
    @Column(name="RES_ID", insertable=false, updatable=false, nullable=false)
    private Long myResourcePid;
    @FullTextField
    @Column(name="RES_TYPE", updatable=false, nullable=false, length=100)
    private String myResourceType;
    @GenericField
    @Column(name="SP_UPDATED", nullable=true)
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date myUpdated;
    @Transient
    private transient PartitionSettings myPartitionSettings;
    @Transient
    private transient StorageSettings myStorageSettings;

    @Override
    public abstract Long getId();

    public String getParamName() {
        return this.myParamName;
    }

    public void setParamName(String theName) {
        if (!StringUtils.equals((CharSequence)this.myParamName, (CharSequence)theName)) {
            this.myParamName = theName;
            this.clearHashes();
        }
    }

    public abstract ResourceTable getResource();

    public abstract BaseResourceIndexedSearchParam setResource(ResourceTable var1);

    @Override
    public <T extends BaseResourceIndex> void copyMutableValuesFrom(T theSource) {
        BaseResourceIndexedSearchParam source = (BaseResourceIndexedSearchParam)theSource;
        this.myMissing = source.myMissing;
        this.myParamName = source.myParamName;
        this.myUpdated = source.myUpdated;
        this.myStorageSettings = source.myStorageSettings;
        this.myPartitionSettings = source.myPartitionSettings;
        this.setPartitionId(source.getPartitionId());
    }

    public Long getResourcePid() {
        return this.myResourcePid;
    }

    public String getResourceType() {
        return this.myResourceType;
    }

    public void setResourceType(String theResourceType) {
        this.myResourceType = theResourceType;
    }

    public Date getUpdated() {
        return this.myUpdated;
    }

    public void setUpdated(Date theUpdated) {
        this.myUpdated = theUpdated;
    }

    public boolean isMissing() {
        return this.myMissing;
    }

    public BaseResourceIndexedSearchParam setMissing(boolean theMissing) {
        this.myMissing = theMissing;
        return this;
    }

    public abstract IQueryParameterType toQueryParameterType();

    public boolean matches(IQueryParameterType theParam) {
        throw new UnsupportedOperationException(Msg.code((int)1526) + "No parameter matcher for " + theParam);
    }

    public PartitionSettings getPartitionSettings() {
        return this.myPartitionSettings;
    }

    public BaseResourceIndexedSearchParam setPartitionSettings(PartitionSettings thePartitionSettings) {
        this.myPartitionSettings = thePartitionSettings;
        return this;
    }

    public StorageSettings getStorageSettings() {
        return this.myStorageSettings;
    }

    public BaseResourceIndexedSearchParam setStorageSettings(StorageSettings theStorageSettings) {
        this.myStorageSettings = theStorageSettings;
        return this;
    }

    public static long calculateHashIdentity(PartitionSettings thePartitionSettings, PartitionablePartitionId theRequestPartitionId, String theResourceType, String theParamName) {
        RequestPartitionId requestPartitionId = PartitionablePartitionId.toRequestPartitionId(theRequestPartitionId);
        return BaseResourceIndexedSearchParam.calculateHashIdentity(thePartitionSettings, requestPartitionId, theResourceType, theParamName);
    }

    public static long calculateHashIdentity(PartitionSettings thePartitionSettings, RequestPartitionId theRequestPartitionId, String theResourceType, String theParamName) {
        return BaseResourceIndexedSearchParam.hash(thePartitionSettings, theRequestPartitionId, theResourceType, theParamName);
    }

    public static long calculateHashIdentity(PartitionSettings thePartitionSettings, RequestPartitionId theRequestPartitionId, String theResourceType, String theParamName, List<String> theAdditionalValues) {
        String[] values = new String[theAdditionalValues.size() + 2];
        values[0] = theResourceType;
        values[1] = theParamName;
        for (int i = 0; i < theAdditionalValues.size(); ++i) {
            values[i + 2] = theAdditionalValues.get(i);
        }
        return BaseResourceIndexedSearchParam.hash(thePartitionSettings, theRequestPartitionId, values);
    }

    static long hash(PartitionSettings thePartitionSettings, RequestPartitionId theRequestPartitionId, String ... theValues) {
        Hasher hasher = HASH_FUNCTION.newHasher();
        if (thePartitionSettings.isPartitioningEnabled() && thePartitionSettings.isIncludePartitionInSearchHashes() && theRequestPartitionId != null) {
            if (theRequestPartitionId.getPartitionIds().size() > 1) {
                throw new InternalErrorException(Msg.code((int)1527) + "Can not search multiple partitions when partitions are included in search hashes");
            }
            Integer partitionId = theRequestPartitionId.getFirstPartitionIdOrNull();
            if (partitionId != null) {
                hasher.putInt(partitionId.intValue());
            }
        }
        for (String next : theValues) {
            if (next == null) {
                hasher.putByte((byte)0);
            } else {
                next = UrlUtil.escapeUrlParam((String)next);
                byte[] bytes = next.getBytes(Charsets.UTF_8);
                hasher.putBytes(bytes);
            }
            hasher.putBytes(DELIMITER_BYTES);
        }
        HashCode hashCode = hasher.hash();
        long retVal = hashCode.asLong();
        return retVal;
    }
}

