/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.model.entity;

import ca.uhn.fhir.jpa.model.entity.BaseTag;
import ca.uhn.fhir.jpa.model.entity.PartitionablePartitionId;
import ca.uhn.fhir.jpa.model.entity.ResourceHistoryTable;
import ca.uhn.fhir.jpa.model.entity.TagDefinition;
import jakarta.persistence.Column;
import jakarta.persistence.Embeddable;
import jakarta.persistence.Entity;
import jakarta.persistence.ForeignKey;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.Index;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.SequenceGenerator;
import jakarta.persistence.Table;
import jakarta.persistence.UniqueConstraint;
import java.io.Serializable;

@Embeddable
@Entity
@Table(name="HFJ_HISTORY_TAG", uniqueConstraints={@UniqueConstraint(name="IDX_RESHISTTAG_TAGID", columnNames={"RES_VER_PID", "TAG_ID"})}, indexes={@Index(name="IDX_RESHISTTAG_RESID", columnList="RES_ID")})
public class ResourceHistoryTag
extends BaseTag
implements Serializable {
    private static final long serialVersionUID = 1L;
    @SequenceGenerator(name="SEQ_HISTORYTAG_ID", sequenceName="SEQ_HISTORYTAG_ID")
    @GeneratedValue(strategy=GenerationType.AUTO, generator="SEQ_HISTORYTAG_ID")
    @Id
    @Column(name="PID")
    private Long myId;
    @ManyToOne
    @JoinColumn(name="RES_VER_PID", referencedColumnName="PID", nullable=false, foreignKey=@ForeignKey(name="FK_HISTORYTAG_HISTORY"))
    private ResourceHistoryTable myResourceHistory;
    @Column(name="RES_VER_PID", insertable=false, updatable=false, nullable=false)
    private Long myResourceHistoryPid;
    @Column(name="RES_TYPE", length=40, nullable=false)
    private String myResourceType;
    @Column(name="RES_ID", nullable=false)
    private Long myResourceId;

    public ResourceHistoryTag() {
    }

    public ResourceHistoryTag(ResourceHistoryTable theResourceHistoryTable, TagDefinition theTag, PartitionablePartitionId theRequestPartitionId) {
        this();
        this.setTag(theTag);
        this.setResource(theResourceHistoryTable);
        this.setResourceId(theResourceHistoryTable.getResourceId());
        this.setResourceType(theResourceHistoryTable.getResourceType());
        this.setPartitionId(theRequestPartitionId);
    }

    public String getResourceType() {
        return this.myResourceType;
    }

    public void setResourceType(String theResourceType) {
        this.myResourceType = theResourceType;
    }

    public Long getResourceId() {
        return this.myResourceId;
    }

    public void setResourceId(Long theResourceId) {
        this.myResourceId = theResourceId;
    }

    public ResourceHistoryTable getResourceHistory() {
        return this.myResourceHistory;
    }

    public void setResource(ResourceHistoryTable theResourceHistory) {
        this.myResourceHistory = theResourceHistory;
    }

    public Long getId() {
        return this.myId;
    }
}

