/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.model.entity;

import ca.uhn.fhir.interceptor.model.RequestPartitionId;
import ca.uhn.fhir.jpa.model.config.PartitionSettings;
import ca.uhn.fhir.jpa.model.entity.BaseResourceIndex;
import ca.uhn.fhir.jpa.model.entity.BaseResourceIndexedSearchParam;
import ca.uhn.fhir.jpa.model.entity.IResourceIndexComboSearchParameter;
import ca.uhn.fhir.jpa.model.entity.PartitionablePartitionId;
import ca.uhn.fhir.jpa.model.entity.ResourceTable;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.ForeignKey;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.Index;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.SequenceGenerator;
import jakarta.persistence.Table;
import jakarta.persistence.Transient;
import org.apache.commons.lang3.builder.CompareToBuilder;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.hl7.fhir.instance.model.api.IIdType;

@Entity
@Table(name="HFJ_IDX_CMB_TOK_NU", indexes={@Index(name="IDX_IDXCMBTOKNU_STR", columnList="IDX_STRING", unique=false), @Index(name="IDX_IDXCMBTOKNU_RES", columnList="RES_ID", unique=false)})
public class ResourceIndexedComboTokenNonUnique
extends BaseResourceIndex
implements Comparable<ResourceIndexedComboTokenNonUnique>,
IResourceIndexComboSearchParameter {
    @SequenceGenerator(name="SEQ_IDXCMBTOKNU_ID", sequenceName="SEQ_IDXCMBTOKNU_ID")
    @GeneratedValue(strategy=GenerationType.AUTO, generator="SEQ_IDXCMBTOKNU_ID")
    @Id
    @Column(name="PID")
    private Long myId;
    @ManyToOne
    @JoinColumn(name="RES_ID", referencedColumnName="RES_ID", foreignKey=@ForeignKey(name="FK_IDXCMBTOKNU_RES_ID"))
    private ResourceTable myResource;
    @Column(name="RES_ID", insertable=false, updatable=false)
    private Long myResourceId;
    @Column(name="HASH_COMPLETE", nullable=false)
    private Long myHashComplete;
    @Column(name="IDX_STRING", nullable=false, length=500)
    private String myIndexString;
    @Transient
    private transient PartitionSettings myPartitionSettings;
    @Transient
    private IIdType mySearchParameterId;

    public ResourceIndexedComboTokenNonUnique() {
    }

    public ResourceIndexedComboTokenNonUnique(PartitionSettings thePartitionSettings, ResourceTable theEntity, String theQueryString) {
        this.myPartitionSettings = thePartitionSettings;
        this.myResource = theEntity;
        this.myIndexString = theQueryString;
        this.calculateHashes();
    }

    @Override
    public String getIndexString() {
        return this.myIndexString;
    }

    public void setIndexString(String theIndexString) {
        this.myIndexString = theIndexString;
    }

    @Override
    public boolean equals(Object theO) {
        if (this == theO) {
            return true;
        }
        if (theO == null || this.getClass() != theO.getClass()) {
            return false;
        }
        ResourceIndexedComboTokenNonUnique that = (ResourceIndexedComboTokenNonUnique)theO;
        EqualsBuilder b = new EqualsBuilder();
        b.append((Object)this.myIndexString, (Object)that.myIndexString);
        return b.isEquals();
    }

    @Override
    public <T extends BaseResourceIndex> void copyMutableValuesFrom(T theSource) {
        ResourceIndexedComboTokenNonUnique source = (ResourceIndexedComboTokenNonUnique)theSource;
        this.myPartitionSettings = source.myPartitionSettings;
        this.myHashComplete = source.myHashComplete;
        this.myIndexString = source.myIndexString;
    }

    @Override
    public Long getId() {
        return this.myId;
    }

    @Override
    public void setId(Long theId) {
        this.myId = theId;
    }

    @Override
    public void clearHashes() {
        this.myHashComplete = null;
    }

    @Override
    public void calculateHashes() {
        if (this.myHashComplete != null) {
            return;
        }
        PartitionSettings partitionSettings = this.getPartitionSettings();
        PartitionablePartitionId partitionId = this.getPartitionId();
        String queryString = this.myIndexString;
        this.setHashComplete(ResourceIndexedComboTokenNonUnique.calculateHashComplete(partitionSettings, partitionId, queryString));
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder(17, 37).append((Object)this.myIndexString).toHashCode();
    }

    public PartitionSettings getPartitionSettings() {
        return this.myPartitionSettings;
    }

    public void setPartitionSettings(PartitionSettings thePartitionSettings) {
        this.myPartitionSettings = thePartitionSettings;
    }

    @Override
    public ResourceTable getResource() {
        return this.myResource;
    }

    @Override
    public void setResource(ResourceTable theResource) {
        this.myResource = theResource;
    }

    public Long getHashComplete() {
        return this.myHashComplete;
    }

    public void setHashComplete(Long theHashComplete) {
        this.myHashComplete = theHashComplete;
    }

    @Override
    public int compareTo(ResourceIndexedComboTokenNonUnique theO) {
        CompareToBuilder b = new CompareToBuilder();
        b.append((Object)this.myHashComplete, (Object)theO.getHashComplete());
        return b.toComparison();
    }

    @Override
    public String toString() {
        return new ToStringBuilder((Object)this).append("id", (Object)this.myId).append("resourceId", (Object)this.myResourceId).append("hashComplete", (Object)this.myHashComplete).append("indexString", (Object)this.myIndexString).toString();
    }

    public static long calculateHashComplete(PartitionSettings partitionSettings, PartitionablePartitionId thePartitionId, String queryString) {
        RequestPartitionId requestPartitionId = PartitionablePartitionId.toRequestPartitionId(thePartitionId);
        return BaseResourceIndexedSearchParam.hash(partitionSettings, requestPartitionId, queryString);
    }

    public static long calculateHashComplete(PartitionSettings partitionSettings, RequestPartitionId partitionId, String queryString) {
        return BaseResourceIndexedSearchParam.hash(partitionSettings, partitionId, queryString);
    }

    @Override
    public void setSearchParameterId(IIdType theSearchParameterId) {
        this.mySearchParameterId = theSearchParameterId;
    }

    @Override
    public IIdType getSearchParameterId() {
        return this.mySearchParameterId;
    }
}

