/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.model.entity;

import ca.uhn.fhir.jpa.model.config.PartitionSettings;
import ca.uhn.fhir.jpa.model.entity.BaseResourceIndex;
import ca.uhn.fhir.jpa.model.entity.BaseResourceIndexedSearchParam;
import ca.uhn.fhir.jpa.model.entity.ResourceTable;
import ca.uhn.fhir.model.api.IQueryParameterType;
import ca.uhn.fhir.rest.param.NumberParam;
import jakarta.persistence.Column;
import jakarta.persistence.Embeddable;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.ForeignKey;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.Index;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.SequenceGenerator;
import jakarta.persistence.Table;
import java.math.BigDecimal;
import java.util.Objects;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.hibernate.annotations.JdbcTypeCode;
import org.hibernate.search.mapper.pojo.mapping.definition.annotation.ScaledNumberField;

@Embeddable
@Entity
@Table(name="HFJ_SPIDX_NUMBER", indexes={@Index(name="IDX_SP_NUMBER_HASH_VAL_V2", columnList="HASH_IDENTITY,SP_VALUE,RES_ID,PARTITION_ID"), @Index(name="IDX_SP_NUMBER_RESID_V2", columnList="RES_ID, HASH_IDENTITY, SP_VALUE, PARTITION_ID")})
public class ResourceIndexedSearchParamNumber
extends BaseResourceIndexedSearchParam {
    private static final long serialVersionUID = 1L;
    @Column(name="SP_VALUE", nullable=true, precision=19, scale=2)
    @ScaledNumberField
    @JdbcTypeCode(value=3)
    public BigDecimal myValue;
    @Id
    @SequenceGenerator(name="SEQ_SPIDX_NUMBER", sequenceName="SEQ_SPIDX_NUMBER")
    @GeneratedValue(strategy=GenerationType.AUTO, generator="SEQ_SPIDX_NUMBER")
    @Column(name="SP_ID")
    private Long myId;
    @Column(name="HASH_IDENTITY", nullable=true)
    private Long myHashIdentity;
    @ManyToOne(optional=false, fetch=FetchType.LAZY, cascade={})
    @JoinColumn(foreignKey=@ForeignKey(name="FK_SP_NUMBER_RES"), name="RES_ID", referencedColumnName="RES_ID", nullable=false)
    private ResourceTable myResource;

    public ResourceIndexedSearchParamNumber() {
    }

    public ResourceIndexedSearchParamNumber(PartitionSettings thePartitionSettings, String theResourceType, String theParamName, BigDecimal theValue) {
        this.setPartitionSettings(thePartitionSettings);
        this.setResourceType(theResourceType);
        this.setParamName(theParamName);
        this.setValue(theValue);
        this.calculateHashes();
    }

    @Override
    public <T extends BaseResourceIndex> void copyMutableValuesFrom(T theSource) {
        super.copyMutableValuesFrom(theSource);
        ResourceIndexedSearchParamNumber source = (ResourceIndexedSearchParamNumber)theSource;
        this.myValue = source.myValue;
        this.myHashIdentity = source.myHashIdentity;
    }

    @Override
    public void clearHashes() {
        this.myHashIdentity = null;
    }

    @Override
    public void calculateHashes() {
        if (this.myHashIdentity != null) {
            return;
        }
        String resourceType = this.getResourceType();
        String paramName = this.getParamName();
        this.setHashIdentity(ResourceIndexedSearchParamNumber.calculateHashIdentity(this.getPartitionSettings(), this.getPartitionId(), resourceType, paramName));
    }

    public Long getHashIdentity() {
        return this.myHashIdentity;
    }

    @Override
    public boolean equals(Object theObj) {
        if (this == theObj) {
            return true;
        }
        if (theObj == null) {
            return false;
        }
        if (!(theObj instanceof ResourceIndexedSearchParamNumber)) {
            return false;
        }
        ResourceIndexedSearchParamNumber obj = (ResourceIndexedSearchParamNumber)theObj;
        EqualsBuilder b = new EqualsBuilder();
        b.append((Object)this.getResourceType(), (Object)obj.getResourceType());
        b.append((Object)this.getParamName(), (Object)obj.getParamName());
        b.append((Object)this.getHashIdentity(), (Object)obj.getHashIdentity());
        b.append((Object)this.normalizeForEqualityComparison(this.getValue()), (Object)this.normalizeForEqualityComparison(obj.getValue()));
        b.append(this.isMissing(), obj.isMissing());
        return b.isEquals();
    }

    private Double normalizeForEqualityComparison(BigDecimal theValue) {
        if (theValue == null) {
            return null;
        }
        return theValue.doubleValue();
    }

    public void setHashIdentity(Long theHashIdentity) {
        this.myHashIdentity = theHashIdentity;
    }

    @Override
    public Long getId() {
        return this.myId;
    }

    @Override
    public void setId(Long theId) {
        this.myId = theId;
    }

    public BigDecimal getValue() {
        return this.myValue;
    }

    public void setValue(BigDecimal theValue) {
        this.myValue = theValue;
    }

    @Override
    public int hashCode() {
        HashCodeBuilder b = new HashCodeBuilder();
        b.append((Object)this.getResourceType());
        b.append((Object)this.getParamName());
        b.append((Object)this.getHashIdentity());
        b.append((Object)this.normalizeForEqualityComparison(this.getValue()));
        b.append(this.isMissing());
        return b.toHashCode();
    }

    @Override
    public IQueryParameterType toQueryParameterType() {
        return new NumberParam(this.myValue.toPlainString());
    }

    @Override
    public String toString() {
        ToStringBuilder b = new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE);
        b.append("paramName", (Object)this.getParamName());
        b.append("resourceId", (Object)this.getResource().getId());
        b.append("value", (Object)this.getValue());
        return b.build();
    }

    @Override
    public boolean matches(IQueryParameterType theParam) {
        if (!(theParam instanceof NumberParam)) {
            return false;
        }
        NumberParam number = (NumberParam)theParam;
        return Objects.equals(this.getValue(), number.getValue());
    }

    @Override
    public ResourceTable getResource() {
        return this.myResource;
    }

    @Override
    public BaseResourceIndexedSearchParam setResource(ResourceTable theResource) {
        this.myResource = theResource;
        this.setResourceType(theResource.getResourceType());
        return this;
    }
}

